/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.common.rules.util.drools;

import java.util.ArrayList;
import java.util.Arrays;
import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseConfiguration;
import org.drools.KnowledgeBaseFactory;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.KnowledgeBuilderConfiguration;
import org.drools.builder.KnowledgeBuilderFactory;
import org.switchyard.common.io.resource.Resource;
import org.switchyard.common.type.Classes;
import org.switchyard.component.common.rules.config.model.ComponentImplementationModel;
import org.switchyard.component.common.rules.util.drools.Configs;
import org.switchyard.component.common.rules.util.drools.Resources;

public final class Bases {
    public static KnowledgeBase newBase(ComponentImplementationModel model) {
        return Bases.newBase(model, null, new Resource[0]);
    }

    public static KnowledgeBase newBase(ComponentImplementationModel model, ClassLoader loader, Resource ... additionalResources) {
        if (loader == null) {
            loader = Classes.getClassLoader(Bases.class);
        }
        KnowledgeBaseConfiguration kbaseConfig = Configs.getBaseConfiguration(model, loader);
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase((KnowledgeBaseConfiguration)kbaseConfig);
        KnowledgeBuilderConfiguration kbuilderConfig = Configs.getBuilderConfiguration(loader);
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder((KnowledgeBase)kbase, (KnowledgeBuilderConfiguration)kbuilderConfig);
        ArrayList<Object> resources = new ArrayList<Object>();
        resources.addAll(model.getResources());
        if (additionalResources != null) {
            resources.addAll(Arrays.asList(additionalResources));
        }
        for (Resource resource : resources) {
            Resources.add(resource, kbuilder, loader);
        }
        return kbuilder.newKnowledgeBase();
    }

    private Bases() {
    }
}

