/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.common.rules.util.drools;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.List;
import org.drools.ChangeSet;
import org.drools.builder.ResourceType;
import org.drools.xml.ChangeSetSemanticModule;
import org.drools.xml.SemanticModule;
import org.drools.xml.SemanticModules;
import org.drools.xml.XmlChangeSetReader;
import org.switchyard.common.io.resource.Resource;
import org.switchyard.common.type.Classes;
import org.switchyard.component.common.rules.util.drools.Resources;
import org.switchyard.exception.SwitchYardException;
import org.xml.sax.SAXException;

public final class ChangeSets {
    public static ChangeSet newChangeSet(List<? extends Resource> resources) {
        return ChangeSets.newChangeSet(resources, null);
    }

    public static ChangeSet newChangeSet(List<? extends Resource> resources, ClassLoader loader) {
        StringBuilder xml = new StringBuilder();
        xml.append("<change-set xmlns='http://drools.org/drools-5.0/change-set' xmlns:xs='http://www.w3.org/2001/XMLSchema-instance' xs:schemaLocation='http://drools.org/drools-5.0/change-set http://anonsvn.jboss.org/repos/labs/labs/jbossrules/trunk/drools-api/src/main/resources/change-set-1.0.0.xsd'>");
        if (loader == null) {
            loader = Classes.getClassLoader(ChangeSet.class);
        }
        for (Resource resource : resources) {
            ChangeSets.addResourceXML(resource, xml, loader);
        }
        xml.append("</change-set>");
        return ChangeSets.newChangeSet(xml.toString(), loader);
    }

    public static ChangeSet newChangeSet(String xml) {
        return ChangeSets.newChangeSet(xml, null);
    }

    public static ChangeSet newChangeSet(String xml, ClassLoader loader) {
        SemanticModules semanticModules = new SemanticModules();
        semanticModules.addSemanticModule((SemanticModule)new ChangeSetSemanticModule());
        XmlChangeSetReader reader = new XmlChangeSetReader(semanticModules);
        if (loader == null) {
            loader = Classes.getClassLoader(ChangeSets.class);
        }
        reader.setClassLoader(loader, null);
        try {
            return reader.read((Reader)new StringReader(xml));
        }
        catch (SAXException saxe) {
            throw new SwitchYardException((Throwable)saxe);
        }
        catch (IOException ioe) {
            throw new SwitchYardException((Throwable)ioe);
        }
    }

    private static void addResourceXML(Resource resource, StringBuilder xml, ClassLoader loader) {
        ResourceType type;
        URL url;
        if (resource != null && (url = resource.getLocationURL(loader)) != null && (type = Resources.convert(resource.getType())) != null) {
            xml.append("<add><resource source='");
            xml.append(url);
            xml.append("' type='");
            xml.append(type.getName());
            xml.append("'/></add>");
        }
    }

    private ChangeSets() {
    }
}

