/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.common.rules.util.drools;

import org.apache.log4j.Logger;
import org.drools.SystemEventListener;

public class LogSystemEventListener
implements SystemEventListener {
    private static final Logger LOGGER = Logger.getLogger(LogSystemEventListener.class);
    private static final String MESSAGE_PREFIX = "Message: ";
    private static final String OBJECT_PREFIX = " , Object: ";

    protected Logger getLogger() {
        return LOGGER;
    }

    protected String getMessagePrefix() {
        return MESSAGE_PREFIX;
    }

    private final String format(String message) {
        return this.getMessagePrefix() + String.valueOf(message);
    }

    private final String format(String message, Object object) {
        return this.getMessagePrefix() + String.valueOf(message) + OBJECT_PREFIX + String.valueOf(object);
    }

    public final void info(String message) {
        this.getLogger().info((Object)this.format(message));
    }

    public final void info(String message, Object object) {
        this.getLogger().info((Object)this.format(message, object));
    }

    public final void warning(String message) {
        this.getLogger().warn((Object)this.format(message));
    }

    public final void warning(String message, Object object) {
        this.getLogger().warn((Object)this.format(message, object));
    }

    public final void exception(Throwable e) {
        this.getLogger().error((Object)this.format(e.getMessage()), e);
    }

    public final void exception(String message, Throwable e) {
        this.getLogger().error((Object)this.format(message), e);
    }

    public final void debug(String message) {
        this.getLogger().debug((Object)this.format(message));
    }

    public final void debug(String message, Object object) {
        this.getLogger().debug((Object)this.format(message, object));
    }
}

