/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.common.rules.util.drools;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.drools.SystemEventListener;
import org.drools.SystemEventListenerFactory;
import org.drools.agent.impl.PrintStreamSystemEventListener;
import org.drools.core.util.DelegatingSystemEventListener;
import org.drools.io.ResourceChangeScanner;
import org.drools.io.ResourceChangeScannerConfiguration;
import org.drools.io.ResourceFactory;
import org.switchyard.component.common.rules.util.drools.LogSystemEventListener;
import org.switchyard.deploy.Component;

public final class ResourceChangeService {
    private static final String DROOLS_RESOURCE_SCANNER_INTERVAL = "drools.resource.scanner.interval";
    private static Set<String> _componentNames = Collections.synchronizedSet(new HashSet());
    private static Lock _componentNamesLock = new ReentrantLock();
    private static SystemEventListener _originalSystemEventListener = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void start(Component component) {
        _componentNamesLock.lock();
        try {
            if (_componentNames.size() == 0) {
                _originalSystemEventListener = SystemEventListenerFactory.getSystemEventListener();
                if (_originalSystemEventListener == null || _originalSystemEventListener instanceof DelegatingSystemEventListener) {
                    _originalSystemEventListener = new PrintStreamSystemEventListener();
                }
                SystemEventListenerFactory.setSystemEventListener((SystemEventListener)new LogSystemEventListener());
                ResourceFactory.getResourceChangeNotifierService().start();
                ResourceChangeScanner rcs = ResourceFactory.getResourceChangeScannerService();
                ResourceChangeScannerConfiguration rcs_conf = rcs.newResourceChangeScannerConfiguration();
                rcs_conf.setProperty(DROOLS_RESOURCE_SCANNER_INTERVAL, "60");
                rcs.configure(rcs_conf);
                rcs.start();
            }
        }
        finally {
            _componentNames.add(component.getName());
            _componentNamesLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stop(Component component) {
        _componentNamesLock.lock();
        try {
            _componentNames.remove(component.getName());
            if (_componentNames.size() == 0) {
                ResourceFactory.getResourceChangeScannerService().stop();
                ResourceFactory.getResourceChangeNotifierService().stop();
                SystemEventListenerFactory.setSystemEventListener((SystemEventListener)_originalSystemEventListener);
            }
        }
        finally {
            _componentNamesLock.unlock();
        }
    }

    private ResourceChangeService() {
    }
}

