/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.soap.config.model;

import javax.xml.namespace.QName;
import org.switchyard.common.net.SocketAddr;
import org.switchyard.component.soap.PortName;
import org.switchyard.component.soap.config.model.InterceptorsModel;
import org.switchyard.component.soap.config.model.SOAPContextMapperModel;
import org.switchyard.component.soap.config.model.SOAPMessageComposerModel;
import org.switchyard.component.soap.config.model.ValueModel;
import org.switchyard.config.Configuration;
import org.switchyard.config.Configurations;
import org.switchyard.config.model.Descriptor;
import org.switchyard.config.model.Model;
import org.switchyard.config.model.composite.v1.V1BindingModel;

public class SOAPBindingModel
extends V1BindingModel {
    public static final String SOAP = "soap";
    public static final String DEFAULT_NAMESPACE = "urn:switchyard-component-soap:config:1.0";
    private static final String WSDL = "wsdl";
    private static final String PORT = "wsdlPort";
    private static final String CONTEXT_PATH = "contextPath";
    private static final String SOCKET_ADDRESS = "socketAddr";
    private static final String ENDPOINT_ADDRESS = "endpointAddress";
    private static final String SECURITY_ACTION = "securityAction";
    private PortName _port;
    private String _wsdl;
    private QName _serviceName;
    private SocketAddr _socketAddr;
    private String _contextPath;
    private Boolean _publishAsWS = false;
    private String _endpointAddress;
    private String _securityAction;
    private InterceptorsModel _inInterceptors;
    private InterceptorsModel _outInterceptors;
    private Configuration _environment = Configurations.emptyConfig();

    public SOAPBindingModel() {
        super(SOAP, DEFAULT_NAMESPACE);
        this.setModelChildrenOrder(new String[]{WSDL, PORT, SOCKET_ADDRESS, CONTEXT_PATH, ENDPOINT_ADDRESS, SECURITY_ACTION, "inInterceptors", "outInterceptors"});
    }

    public SOAPBindingModel(Configuration config, Descriptor desc) {
        super(config, desc);
        this.setModelChildrenOrder(new String[]{WSDL, PORT, SOCKET_ADDRESS, CONTEXT_PATH, ENDPOINT_ADDRESS, SECURITY_ACTION, "inInterceptors", "outInterceptors"});
    }

    public SOAPContextMapperModel getSOAPContextMapper() {
        return (SOAPContextMapperModel)this.getContextMapper();
    }

    public SOAPMessageComposerModel getSOAPMessageComposer() {
        return (SOAPMessageComposerModel)this.getMessageComposer();
    }

    public PortName getPort() {
        if (this._port == null) {
            Configuration childConfig = this.getModelConfiguration().getFirstChild(PORT);
            this._port = childConfig != null ? new PortName(childConfig.getValue()) : new PortName();
        }
        return this._port;
    }

    public void setPort(PortName port) {
        this._port = port;
        Configuration childConfig = this.getModelConfiguration().getFirstChild(PORT);
        if (childConfig == null) {
            ValueModel portConfig = new ValueModel(PORT);
            portConfig.setValue(port.getName());
            this.setChildModel((Model)portConfig);
        } else {
            childConfig.setValue(port.getName());
        }
    }

    public String getWsdl() {
        Configuration childConfig;
        if (this._wsdl == null && (childConfig = this.getModelConfiguration().getFirstChild(WSDL)) != null) {
            this._wsdl = childConfig.getValue();
        }
        return this._wsdl;
    }

    public void setWsdl(String wsdl) {
        this._wsdl = wsdl;
        Configuration childConfig = this.getModelConfiguration().getFirstChild(WSDL);
        if (childConfig == null) {
            ValueModel portConfig = new ValueModel(WSDL);
            portConfig.setValue(wsdl);
            this.setChildModel((Model)portConfig);
        } else {
            childConfig.setValue(wsdl);
        }
    }

    public QName getServiceName() {
        if (this._serviceName == null) {
            this._serviceName = this.isServiceBinding() ? this.getService().getQName() : this.getReference().getQName();
        }
        return this._serviceName;
    }

    public void setServiceName(QName serviceName) {
        this._serviceName = serviceName;
    }

    public SocketAddr getSocketAddr() {
        if (this._socketAddr == null) {
            Configuration hostConfig;
            Configuration childConfig = this.getModelConfiguration().getFirstChild(SOCKET_ADDRESS);
            this._socketAddr = childConfig == null ? ((hostConfig = this._environment.getFirstChild(SOCKET_ADDRESS)) != null && hostConfig.getValue() != null ? new SocketAddr(hostConfig.getValue()) : new SocketAddr()) : new SocketAddr(childConfig.getValue());
        }
        return this._socketAddr;
    }

    public void setSocketAddr(SocketAddr socketAddr) {
        this._socketAddr = socketAddr;
        Configuration childConfig = this.getModelConfiguration().getFirstChild(SOCKET_ADDRESS);
        if (childConfig == null) {
            ValueModel addrConfig = new ValueModel(SOCKET_ADDRESS);
            addrConfig.setValue(socketAddr.toString());
            this.setChildModel((Model)addrConfig);
        } else {
            childConfig.setValue(socketAddr.toString());
        }
    }

    public String getContextPath() {
        if (this._contextPath == null) {
            Configuration childConfig = this.getModelConfiguration().getFirstChild(CONTEXT_PATH);
            if (childConfig == null) {
                Configuration contextConfig = this._environment.getFirstChild(CONTEXT_PATH);
                if (contextConfig != null && contextConfig.getValue() != null) {
                    this._contextPath = contextConfig.getValue();
                }
            } else {
                this._contextPath = childConfig.getValue();
            }
        }
        return this._contextPath;
    }

    public void setContextPath(String contextPath) {
        this._contextPath = contextPath;
    }

    public String getEndpointAddress() {
        Configuration childConfig;
        if (this._endpointAddress == null && (childConfig = this.getModelConfiguration().getFirstChild(ENDPOINT_ADDRESS)) != null) {
            this._endpointAddress = childConfig.getValue();
        }
        return this._endpointAddress;
    }

    public void setEndpointAddress(String endpointAddress) {
        this._endpointAddress = endpointAddress;
    }

    public void setPublishAsWS(Boolean publishAsWS) {
        this._publishAsWS = publishAsWS;
    }

    public Boolean getPublishAsWS() {
        return this._publishAsWS;
    }

    public String getSecurityAction() {
        Configuration childConfig;
        if (this._securityAction == null && (childConfig = this.getModelConfiguration().getFirstChild(SECURITY_ACTION)) != null) {
            this._securityAction = childConfig.getValue();
        }
        return this._securityAction;
    }

    public void setSecurityAction(String securityAction) {
        this._securityAction = securityAction;
    }

    public InterceptorsModel getInInterceptors() {
        if (this._inInterceptors == null) {
            this._inInterceptors = (InterceptorsModel)this.getFirstChildModel("inInterceptors");
        }
        return this._inInterceptors;
    }

    public SOAPBindingModel setInInterceptors(InterceptorsModel inInterceptors) {
        if (inInterceptors != null && !"inInterceptors".equals(inInterceptors.getModelConfiguration().getName())) {
            throw new IllegalArgumentException("not inInterceptors");
        }
        this.setChildModel(inInterceptors);
        this._inInterceptors = inInterceptors;
        return this;
    }

    public InterceptorsModel getOutInterceptors() {
        if (this._outInterceptors == null) {
            this._outInterceptors = (InterceptorsModel)this.getFirstChildModel("outInterceptors");
        }
        return this._outInterceptors;
    }

    public SOAPBindingModel setOutInterceptors(InterceptorsModel outInterceptors) {
        if (outInterceptors != null && !"outInterceptors".equals(outInterceptors.getModelConfiguration().getName())) {
            throw new IllegalArgumentException("not outInterceptors");
        }
        this.setChildModel(outInterceptors);
        this._outInterceptors = outInterceptors;
        return this;
    }

    public void setEnvironment(Configuration config) {
        this._environment = config;
    }
}

