/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.maven.plugins.switchyard;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.switchyard.common.type.Classes;
import org.switchyard.config.model.MergeScanner;
import org.switchyard.config.model.Model;
import org.switchyard.config.model.ModelResourceScanner;
import org.switchyard.config.model.Scanner;
import org.switchyard.config.model.ScannerInput;
import org.switchyard.config.model.switchyard.v1.V1SwitchYardModel;

public class ConfigureMojo<M extends Model>
extends AbstractMojo {
    private String modelClassName;
    private String[] scannerClassNames = new String[0];
    private List<String> compileClasspathElements;
    private List<Resource> resources;
    private String artifactId;
    private File outputDirectory;
    private File outputFile;

    public void execute() throws MojoExecutionException, MojoFailureException {
        final ArrayList<URL> mojoURLs = new ArrayList<URL>();
        try {
            for (String compileClasspaths : this.compileClasspathElements) {
                mojoURLs.add(new File(compileClasspaths).toURI().toURL());
            }
            Resource defaultResource = new Resource();
            defaultResource.setTargetPath(this.outputDirectory.getAbsolutePath());
            this.resources.add(defaultResource);
            for (Resource resource : this.resources) {
                File file;
                String path = resource.getTargetPath();
                if (path == null || !(file = new File(path)).exists()) continue;
                mojoURLs.add(file.toURI().toURL());
            }
        }
        catch (MalformedURLException mue) {
            throw new MojoExecutionException(mue.getMessage(), (Exception)mue);
        }
        ClassLoader loader = AccessController.doPrivileged(new PrivilegedAction<URLClassLoader>(){

            @Override
            public URLClassLoader run() {
                return new URLClassLoader(mojoURLs.toArray(new URL[mojoURLs.size()]), ConfigureMojo.class.getClassLoader());
            }
        });
        ClassLoader previous = Classes.setTCCL((ClassLoader)loader);
        Writer writer = null;
        try {
            ArrayList<Object> scanners = new ArrayList<Object>();
            for (String scannerClassName : this.scannerClassNames) {
                Class scannerClass = Classes.forName((String)scannerClassName, (ClassLoader)loader);
                if (scannerClass == null) continue;
                Scanner scanner = (Scanner)scannerClass.newInstance();
                scanners.add(scanner);
            }
            scanners.add(new ModelResourceScanner());
            if (this.modelClassName == null) {
                this.modelClassName = V1SwitchYardModel.class.getName();
            }
            Class modelClass = Classes.forName((String)this.modelClassName, (ClassLoader)loader);
            MergeScanner merge_scanner = new MergeScanner(modelClass, true, scanners);
            ArrayList<URL> scannerURLs = new ArrayList<URL>();
            scannerURLs.add(this.outputDirectory.toURI().toURL());
            ScannerInput scanner_input = new ScannerInput().setName(this.artifactId).setURLs(scannerURLs);
            Model model = merge_scanner.scan(scanner_input).getModel();
            if (this.outputFile == null) {
                File od = new File(this.outputDirectory, "META-INF");
                if (!od.exists() && !od.mkdirs()) {
                    throw new Exception("mkdirs() on " + od + " failed.");
                }
                this.outputFile = new File(od, "switchyard.xml");
            }
            writer = new BufferedWriter(new FileWriter(this.outputFile));
            model.write(writer);
        }
        catch (Throwable t) {
            throw new MojoExecutionException(t.getMessage(), t);
        }
        finally {
            Classes.setTCCL((ClassLoader)previous);
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException ioe) {
                    throw new MojoExecutionException(ioe.getMessage(), (Exception)ioe);
                }
            }
        }
    }
}

