/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.maven.plugins.switchyard;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.switchyard.common.io.pull.StringPuller;
import org.switchyard.common.lang.Strings;
import org.switchyard.config.Configuration;
import org.switchyard.config.ConfigurationPuller;
import org.switchyard.config.OutputKey;

@Mojo(name="setVersion", defaultPhase=LifecyclePhase.VALIDATE, requiresDirectInvocation=true)
public class SetVersionMojo
extends AbstractMojo {
    private static final String XML_DECLARATION = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
    private static final String XML_COPYRIGHT = "<!--\n  ~ JBoss, Home of Professional Open Source.\n  ~ Copyright YEAR, Red Hat, Inc., and individual contributors\n  ~ as indicated by the @author tags. See the copyright.txt file in the\n  ~ distribution for a full listing of individual contributors.\n  ~\n  ~ This is free software; you can redistribute it and/or modify it\n  ~ under the terms of the GNU Lesser General Public License as\n  ~ published by the Free Software Foundation; either version 2.1 of\n  ~ the License, or (at your option) any later version.\n  ~\n  ~ This software is distributed in the hope that it will be useful,\n  ~ but WITHOUT ANY WARRANTY; without even the implied warranty of\n  ~ MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU\n  ~ Lesser General Public License for more details.\n  ~\n  ~ You should have received a copy of the GNU Lesser General Public\n  ~ License along with this software; if not, write to the Free\n  ~ Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA\n  ~ 02110-1301 USA, or see the FSF site: http://www.fsf.org.\n  -->\n";
    @Parameter(property="project.file", required=true)
    private File _project_file;
    @Parameter(property="oldVersion", required=true)
    private String _oldVersion;
    @Parameter(property="newVersion", required=true)
    private String _newVersion;
    @Parameter(property="prettyPrint", alias="prettyPrint")
    private boolean _prettyPrint = true;
    private String _oldVersion_pom;
    private String _oldVersion_download;
    private String _oldVersion_distro;
    private String _newVersion_pom;
    private String _newVersion_download;
    private String _newVersion_distro;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.parseVersion(this._oldVersion, true);
        this.parseVersion(this._newVersion, false);
        AtomicBoolean projectModified = new AtomicBoolean(false);
        try {
            Configuration project = (Configuration)new ConfigurationPuller(false).pull(this._project_file);
            if (project != null) {
                Configuration project_properties;
                String ppgid;
                Configuration project_parent_groupId;
                this.setVersion(project.getFirstChild("version"), this._newVersion_pom, projectModified);
                Configuration project_parent = project.getFirstChild("parent");
                if (project_parent != null && (project_parent_groupId = project_parent.getFirstChild("groupId")) != null && (ppgid = Strings.trimToNull((String)project_parent_groupId.getValue())) != null && ppgid.startsWith("org.switchyard")) {
                    this.setVersion(project_parent.getFirstChild("version"), this._newVersion_pom, projectModified);
                }
                if ((project_properties = project.getFirstChild("properties")) != null) {
                    this.setVersion(project_properties.getFirstChild("switchyard.version"), this._newVersion_pom, projectModified);
                    this.setVersion(project_properties.getFirstChild("version.switchyard.runtime"), this._newVersion_pom, projectModified);
                    this.setVersion(project_properties.getFirstChild("version.distro"), this._newVersion_distro, projectModified);
                }
                if (projectModified.get()) {
                    this.getLog().info((CharSequence)(this._project_file.getAbsolutePath() + " modified. Writing..."));
                    this.write(project, this._project_file);
                } else {
                    this.getLog().info((CharSequence)(this._project_file.getAbsolutePath() + " not modified. Skipping..."));
                }
                File installerFile = new File(new File(this._project_file.getParentFile(), "scripts"), "installer.properties");
                if (installerFile.exists()) {
                    String[][] replacements;
                    String installerOld;
                    String installerNew = installerOld = (String)new StringPuller().pull(installerFile);
                    for (String[] replacement : replacements = new String[][]{{this._oldVersion_pom, this._newVersion_pom}, {this._oldVersion_download, this._newVersion_download}, {this._oldVersion_distro, this._newVersion_distro}}) {
                        replacement[0] = replacement[0].replaceAll("\\.", "\\\\.");
                        installerNew = installerNew.replaceAll(replacement[0], replacement[1]);
                    }
                    if (!installerNew.equals(installerOld)) {
                        this.getLog().info((CharSequence)(installerFile.getAbsolutePath() + " modified. Writing..."));
                        this.write(installerNew, installerFile);
                    } else {
                        this.getLog().info((CharSequence)(installerFile.getAbsolutePath() + " not modified. Skipping..."));
                    }
                }
            }
        }
        catch (IOException ioe) {
            throw new MojoExecutionException(ioe.getMessage(), (Exception)ioe);
        }
    }

    private void parseVersion(String version, boolean old) throws MojoExecutionException {
        String[] dashSplit;
        if ((version = Strings.trimToNull((String)version)) == null) {
            throw new MojoExecutionException((old ? "old" : "new") + "Version unspecified");
        }
        String[] dotSplit = version.split("\\.", 4);
        String major = dotSplit.length > 0 ? dotSplit[0] : null;
        String minor = dotSplit.length > 1 ? dotSplit[1] : null;
        String incremental = dotSplit.length > 2 ? dotSplit[2] : null;
        String qualifier = dotSplit.length > 3 ? dotSplit[3] : null;
        boolean dash = false;
        if (incremental != null && qualifier == null && (dashSplit = incremental.split("-", 2)).length > 1) {
            incremental = dashSplit[0];
            qualifier = dashSplit[1];
            dash = true;
        }
        boolean numbers = false;
        try {
            Integer.parseInt(major);
            Integer.parseInt(minor);
            Integer.parseInt(incremental);
            numbers = true;
        }
        catch (NumberFormatException nfe) {
            this.getLog().error((CharSequence)(NumberFormatException.class.getSimpleName() + ": " + nfe.getMessage()));
        }
        if (!numbers || qualifier == null) {
            String emsg = String.format("Could not parse %s version [%s]: major=%s, minor=%s, incremental=%s, dash=%b, qualifier=%s", old ? "old" : "new", version, major, minor, incremental, dash, qualifier);
            throw new MojoExecutionException(emsg);
        }
        String pom = major + '.' + minor + '.' + incremental + (dash ? (char)'-' : '.') + qualifier;
        String download = 'v' + major + '.' + minor + '.' + qualifier;
        String distro = major + '.' + minor;
        if (old) {
            this._oldVersion_pom = pom;
            this._oldVersion_download = download;
            this._oldVersion_distro = distro;
        } else {
            this._newVersion_pom = pom;
            this._newVersion_download = download;
            this._newVersion_distro = distro;
        }
    }

    private void setVersion(Configuration config, String newVersion, AtomicBoolean modified) {
        if (config != null) {
            String oldVersion = config.getValue();
            if (newVersion.equals(oldVersion)) {
                this.getLog().info((CharSequence)String.format("old version already matches new version: %s - skipping...", newVersion));
                return;
            }
            config.setValue(newVersion);
            modified.set(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write(Configuration config, File file) throws IOException {
        BufferedWriter writer = new BufferedWriter(new FileWriter(file));
        try {
            writer.write(XML_DECLARATION);
            writer.write(XML_COPYRIGHT.replaceFirst("YEAR", new SimpleDateFormat("yyyy").format(new Date())));
            if (this._prettyPrint) {
                config.write((Writer)writer, new OutputKey[]{OutputKey.OMIT_XML_DECLARATION, OutputKey.PRETTY_PRINT});
            } else {
                config.write((Writer)writer, new OutputKey[]{OutputKey.OMIT_XML_DECLARATION});
                writer.write("\n");
            }
            ((Writer)writer).flush();
        }
        finally {
            ((Writer)writer).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write(String content, File file) throws IOException {
        BufferedWriter writer = new BufferedWriter(new FileWriter(file));
        try {
            writer.write(content);
            ((Writer)writer).flush();
        }
        finally {
            ((Writer)writer).close();
        }
    }

    public static void main(String ... args) throws Exception {
        String[] oldVersions = new String[]{"0.6.0-SNAPSHOT", "0.6.0.Beta1", "0.6.0.Final"};
        String[] newVersions = new String[]{"0.6.0.Final", "0.6.0-SNAPSHOT", "0.7.0-SNAPSHOT"};
        for (int i = 0; i < oldVersions.length; ++i) {
            SetVersionMojo m = new SetVersionMojo();
            m._oldVersion = oldVersions[i];
            m._newVersion = newVersions[i];
            m.parseVersion(m._oldVersion, true);
            m.parseVersion(m._newVersion, false);
            System.out.println(String.format("_oldVersion_pom[%s], _oldVersion_download[%s], _oldVersion_distro[%s], _newVersion_pom[%s], _newVersion_download[%s], _newVersion_distro[%s]", m._oldVersion_pom, m._oldVersion_download, m._oldVersion_distro, m._newVersion_pom, m._newVersion_download, m._newVersion_distro));
        }
    }
}

