/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.security.jboss.provider;

import javax.security.auth.Subject;
import org.jboss.security.SecurityContextAssociation;
import org.switchyard.ServiceSecurity;
import org.switchyard.security.context.SecurityContext;
import org.switchyard.security.jboss.JBossSecurityLogger;
import org.switchyard.security.provider.JaasSecurityProvider;

public class JBossJaasSecurityProvider
extends JaasSecurityProvider {
    public boolean propagate(ServiceSecurity serviceSecurity, SecurityContext securityContext) {
        String jb_securityDomain;
        String sy_securityDomain;
        org.jboss.security.SecurityContext jb_securityContext = SecurityContextAssociation.getSecurityContext();
        if (jb_securityContext != null && (sy_securityDomain = serviceSecurity.getSecurityDomain()).equals(jb_securityDomain = jb_securityContext.getSecurityDomain())) {
            Subject sy_subject = securityContext.getSubject(sy_securityDomain);
            Subject jb_subject = jb_securityContext.getUtil().getSubject();
            if (jb_subject != null && sy_subject != jb_subject && !sy_subject.equals(jb_subject)) {
                sy_subject.getPrincipals().addAll(jb_subject.getPrincipals());
                sy_subject.getPrivateCredentials().addAll(jb_subject.getPrivateCredentials());
                sy_subject.getPublicCredentials().addAll(jb_subject.getPublicCredentials());
            }
            return true;
        }
        return false;
    }

    public boolean clear(ServiceSecurity serviceSecurity, SecurityContext securityContext) {
        boolean success = super.clear(serviceSecurity, securityContext);
        try {
            String jb_securityDomain;
            String sy_securityDomain;
            org.jboss.security.SecurityContext jb_securityContext = SecurityContextAssociation.getSecurityContext();
            if (jb_securityContext != null && (sy_securityDomain = serviceSecurity.getSecurityDomain()).equals(jb_securityDomain = jb_securityContext.getSecurityDomain())) {
                SecurityContextAssociation.clearSecurityContext();
            }
        }
        catch (Throwable t) {
            JBossSecurityLogger.ROOT_LOGGER.clearSecurityContextAssociation(t);
            success = false;
        }
        return success;
    }

    static {
        SecurityContextAssociation.getSecurityContext();
    }
}

