/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.security.jboss.provider;

import java.security.Principal;
import java.security.acl.Group;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.security.auth.Subject;
import org.jboss.security.RunAs;
import org.jboss.security.RunAsIdentity;
import org.jboss.security.SecurityContextAssociation;
import org.jboss.security.SecurityContextFactory;
import org.jboss.security.identity.Identity;
import org.jboss.security.identity.Role;
import org.jboss.security.identity.RoleGroup;
import org.jboss.security.identity.extensions.CredentialIdentity;
import org.jboss.security.identity.extensions.CredentialIdentityFactory;
import org.jboss.security.identity.plugins.SimpleRoleGroup;
import org.jboss.security.mapping.MappingResult;
import org.picketlink.identity.federation.bindings.jboss.auth.mapping.STSGroupMappingProvider;
import org.picketlink.identity.federation.bindings.jboss.auth.mapping.STSPrincipalMappingProvider;
import org.switchyard.ServiceSecurity;
import org.switchyard.security.context.SecurityContext;
import org.switchyard.security.credential.AssertionCredential;
import org.switchyard.security.jboss.JBossSecurityLogger;
import org.switchyard.security.principal.GroupPrincipal;
import org.switchyard.security.principal.RolePrincipal;
import org.switchyard.security.principal.UserPrincipal;
import org.switchyard.security.provider.DefaultSecurityProvider;
import org.w3c.dom.Element;

public class JBossSecurityProvider
extends DefaultSecurityProvider {
    public void populate(ServiceSecurity serviceSecurity, SecurityContext securityContext) {
        String sy_securityDomain = serviceSecurity.getSecurityDomain();
        Subject sy_subject = securityContext.getSubject(sy_securityDomain);
        org.jboss.security.SecurityContext jb_securityContext = SecurityContextAssociation.getSecurityContext();
        if (jb_securityContext != null) {
            String jb_securityDomain = jb_securityContext.getSecurityDomain();
            if (sy_securityDomain.equals(jb_securityDomain)) {
                Subject jb_subject = jb_securityContext.getUtil().getSubject();
                this.transfer(jb_subject, sy_subject);
            }
        } else {
            Set assertionCredentials = securityContext.getCredentials(AssertionCredential.class);
            for (AssertionCredential assertionCredential : assertionCredentials) {
                Element assertionElement = assertionCredential.getAssertion();
                if (assertionElement == null) continue;
                Subject sts_subject = new Subject();
                boolean sts_mapped = false;
                HashMap<String, Element> contextMap = new HashMap<String, Element>();
                contextMap.put("org.picketlink.identity.federation.core.wstrust.lm.stsToken", assertionElement);
                STSPrincipalMappingProvider principalMapper = new STSPrincipalMappingProvider();
                principalMapper.init(contextMap);
                MappingResult principalResult = new MappingResult();
                principalMapper.setMappingResult(principalResult);
                principalMapper.performMapping(contextMap, null);
                Principal principal = (Principal)principalResult.getMappedObject();
                if (principal != null) {
                    sts_subject.getPrincipals().add((Principal)new UserPrincipal(principal.getName()));
                    sts_mapped = true;
                }
                STSGroupMappingProvider rolesMapper = new STSGroupMappingProvider();
                rolesMapper.init(contextMap);
                MappingResult rolesResult = new MappingResult();
                rolesMapper.setMappingResult(rolesResult);
                rolesMapper.performMapping(contextMap, null);
                RoleGroup roleGroup = (RoleGroup)rolesResult.getMappedObject();
                if (roleGroup != null) {
                    GroupPrincipal roles = null;
                    for (Role role : roleGroup.getRoles()) {
                        if (roles == null) {
                            roles = new GroupPrincipal("Roles");
                        }
                        roles.addMember((Principal)new RolePrincipal(role.getRoleName()));
                    }
                    if (roles != null) {
                        sts_subject.getPrincipals().add((Principal)roles);
                        sts_mapped = true;
                    }
                }
                if (!sts_mapped) continue;
                this.transfer(sts_subject, sy_subject);
            }
        }
        super.populate(serviceSecurity, securityContext);
    }

    protected Object setContainerContext(String securityDomain, Subject subject, Principal principal, Group rolesGroup, String runAs) throws Exception {
        HashSet<String> roles = new HashSet<String>();
        if (runAs != null) {
            roles.add(runAs);
        }
        if (rolesGroup != null) {
            for (Principal role : Collections.list(rolesGroup.members())) {
                if (runAs == null) {
                    runAs = role.getName();
                }
                roles.add(role.getName());
            }
        }
        RunAsIdentity new_jb_runAs = runAs != null ? new RunAsIdentity(runAs, principal != null ? principal.getName() : null, roles) : null;
        org.jboss.security.SecurityContext old_jb_securityContext = SecurityContextAssociation.getSecurityContext();
        if (old_jb_securityContext == null) {
            Set<Object> credentials = subject.getPrivateCredentials();
            Object credential = !credentials.isEmpty() ? credentials.iterator().next() : null;
            org.jboss.security.SecurityContext new_jb_securityContext = SecurityContextFactory.createSecurityContext((String)securityDomain);
            SecurityContextAssociation.setSecurityContext((org.jboss.security.SecurityContext)new_jb_securityContext);
            if (rolesGroup != null) {
                SimpleRoleGroup roleGroup = new SimpleRoleGroup(rolesGroup);
                CredentialIdentity identity = CredentialIdentityFactory.createIdentity((Principal)principal, (Object)credential, (Role)roleGroup);
                new_jb_securityContext.getUtil().createSubjectInfo((Identity)identity, subject);
                new_jb_securityContext.getSubjectInfo().setRoles((RoleGroup)roleGroup);
            } else {
                CredentialIdentity identity = CredentialIdentityFactory.createIdentity((Principal)principal, (Object)credential);
                new_jb_securityContext.getUtil().createSubjectInfo((Identity)identity, subject);
            }
            if (new_jb_runAs != null) {
                new_jb_securityContext.setOutgoingRunAs((RunAs)new_jb_runAs);
            }
            return new JBossContainerContext(null, null, null);
        }
        RoleGroup old_jb_roleGroup = old_jb_securityContext.getSubjectInfo().getRoles();
        if (rolesGroup != null) {
            old_jb_securityContext.getSubjectInfo().setRoles((RoleGroup)new SimpleRoleGroup(rolesGroup));
        }
        RunAs old_jb_runAs = old_jb_securityContext.getOutgoingRunAs();
        if (new_jb_runAs != null) {
            old_jb_securityContext.setOutgoingRunAs((RunAs)new_jb_runAs);
        }
        return new JBossContainerContext(old_jb_securityContext, old_jb_roleGroup, old_jb_runAs);
    }

    protected void resetContainerContext(Object previous) throws Exception {
        JBossContainerContext old_jb = (JBossContainerContext)previous;
        if (old_jb._securityContext == null) {
            SecurityContextAssociation.clearSecurityContext();
        } else {
            SecurityContextAssociation.setSecurityContext((org.jboss.security.SecurityContext)old_jb._securityContext);
            old_jb._securityContext.getSubjectInfo().setRoles(old_jb._roleGroup);
            old_jb._securityContext.setOutgoingRunAs(old_jb._runAs);
        }
    }

    public void clear(ServiceSecurity serviceSecurity, SecurityContext securityContext) {
        super.clear(serviceSecurity, securityContext);
        try {
            String jb_securityDomain;
            String sy_securityDomain;
            org.jboss.security.SecurityContext jb_securityContext = SecurityContextAssociation.getSecurityContext();
            if (jb_securityContext != null && (sy_securityDomain = serviceSecurity.getSecurityDomain()).equals(jb_securityDomain = jb_securityContext.getSecurityDomain())) {
                SecurityContextAssociation.clearSecurityContext();
            }
        }
        catch (Throwable t) {
            JBossSecurityLogger.ROOT_LOGGER.clearSecurityContextAssociation(t);
        }
    }

    static {
        SecurityContextAssociation.getSecurityContext();
    }

    private static final class JBossContainerContext {
        private final org.jboss.security.SecurityContext _securityContext;
        private final RoleGroup _roleGroup;
        private final RunAs _runAs;

        private JBossContainerContext(org.jboss.security.SecurityContext securityContext, RoleGroup roleGroup, RunAs runAs) {
            this._securityContext = securityContext;
            this._roleGroup = roleGroup;
            this._runAs = runAs;
        }
    }
}

