/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.security.karaf.provider;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.Principal;
import java.util.Set;
import javax.security.auth.Subject;
import org.apache.karaf.jaas.boot.ProxyLoginModule;
import org.apache.karaf.jaas.boot.principal.GroupPrincipal;
import org.switchyard.ServiceSecurity;
import org.switchyard.security.context.SecurityContext;
import org.switchyard.security.credential.PrincipalCredential;
import org.switchyard.security.provider.DefaultSecurityProvider;

public class KarafSecurityProvider
extends DefaultSecurityProvider {
    public void populate(ServiceSecurity serviceSecurity, SecurityContext securityContext) {
        String securityDomain = serviceSecurity.getSecurityDomain();
        Subject toSubject = securityContext.getSubject(securityDomain);
        Set principalCredentials = securityContext.getCredentials(PrincipalCredential.class);
        for (PrincipalCredential principalCredential : principalCredentials) {
            Principal principal = principalCredential.getPrincipal();
            Method getSubjectMethod = null;
            try {
                getSubjectMethod = principal.getClass().getMethod("getSubject", null);
            }
            catch (NoSuchMethodException e) {
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            if (getSubjectMethod == null) continue;
            Subject fromSubject = null;
            try {
                fromSubject = (Subject)getSubjectMethod.invoke((Object)principal, (Object[])null);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            if (fromSubject == null) continue;
            this.transfer(fromSubject, toSubject);
        }
    }

    public void clear(ServiceSecurity serviceSecurity, SecurityContext securityContext) {
        super.clear(serviceSecurity, securityContext);
    }

    public boolean checkRolesAllowed(ServiceSecurity serviceSecurity, SecurityContext securityContext) {
        Set rolesAllowed = serviceSecurity.getRolesAllowed();
        if (rolesAllowed.isEmpty()) {
            return true;
        }
        String securityDomain = serviceSecurity.getSecurityDomain();
        for (String roleName : rolesAllowed) {
            boolean isInRole = this.isCallerInRole(securityContext, roleName, securityDomain);
            if (!isInRole) continue;
            return true;
        }
        return super.checkRolesAllowed(serviceSecurity, securityContext);
    }

    public boolean isCallerInRole(SecurityContext securityContext, String roleName, String securityDomain) {
        Subject subject = securityContext.getSubject(securityDomain, false);
        if (subject != null) {
            for (Principal principal : subject.getPrincipals()) {
                if (!(principal instanceof GroupPrincipal) || !principal.getName().equalsIgnoreCase(roleName)) continue;
                return true;
            }
        }
        return false;
    }

    static {
        new ProxyLoginModule();
    }
}

