/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.security.credential.extract;

import java.util.Set;
import junit.framework.Assert;
import org.junit.Test;
import org.switchyard.common.io.pull.StringPuller;
import org.switchyard.security.credential.Credential;
import org.switchyard.security.credential.NameCredential;
import org.switchyard.security.credential.PasswordCredential;
import org.switchyard.security.credential.extract.AuthorizationHeaderCredentialsExtractor;

public class AuthorizationHeaderCredentialsExtractorTests {
    private static final String BASE_PATH = "/org/switchyard/security/credential/extract/AuthorizationHeaderCredentialsExtractorTests-";
    private static final String BASIC_TXT = "/org/switchyard/security/credential/extract/AuthorizationHeaderCredentialsExtractorTests-Basic.txt";
    private static final String DIGEST_TXT = "/org/switchyard/security/credential/extract/AuthorizationHeaderCredentialsExtractorTests-Digest.txt";

    @Test
    public void testBasic() throws Exception {
        String source = (String)new StringPuller().pull(BASIC_TXT);
        Set creds = new AuthorizationHeaderCredentialsExtractor().extractCredentials(source);
        boolean foundName = false;
        boolean foundPassword = false;
        for (Credential cred : creds) {
            if (cred instanceof NameCredential) {
                foundName = true;
                String name = ((NameCredential)cred).getName();
                Assert.assertEquals((String)"Aladdin", (String)name);
                continue;
            }
            if (!(cred instanceof PasswordCredential)) continue;
            foundPassword = true;
            String password = new String(((PasswordCredential)cred).getPassword());
            Assert.assertEquals((String)"open sesame", (String)password);
        }
        if (!foundName) {
            Assert.fail((String)"name not found");
        }
        if (!foundPassword) {
            Assert.fail((String)"password not found");
        }
    }

    @Test
    public void testDigest() throws Exception {
        String source = (String)new StringPuller().pull(DIGEST_TXT);
        Set creds = new AuthorizationHeaderCredentialsExtractor().extractCredentials(source);
        boolean foundName = false;
        for (Credential cred : creds) {
            if (!(cred instanceof NameCredential)) continue;
            foundName = true;
            String name = ((NameCredential)cred).getName();
            Assert.assertEquals((String)"Mufasa", (String)name);
        }
        if (!foundName) {
            Assert.fail((String)"name not found");
        }
    }
}

