/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.security.credential.extract;

import java.io.InputStream;
import java.security.cert.Certificate;
import java.util.Set;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPMessage;
import junit.framework.Assert;
import org.junit.Test;
import org.switchyard.common.type.Classes;
import org.switchyard.security.credential.AssertionCredential;
import org.switchyard.security.credential.CertificateCredential;
import org.switchyard.security.credential.Credential;
import org.switchyard.security.credential.NameCredential;
import org.switchyard.security.credential.PasswordCredential;
import org.switchyard.security.credential.extract.SOAPMessageCredentialsExtractor;
import org.w3c.dom.Element;

public class SOAPMessageCredentialsExtractorTests {
    private static final String BASE_PATH = "/org/switchyard/security/credential/extract/SOAPMessageCredentialsExtractorTests-";
    private static final String ASSERTION_XML = "/org/switchyard/security/credential/extract/SOAPMessageCredentialsExtractorTests-Assertion.xml";
    private static final String USERNAME_TOKEN_XML = "/org/switchyard/security/credential/extract/SOAPMessageCredentialsExtractorTests-UsernameToken.xml";
    private static final String BINARY_SECURITY_TOKEN_XML = "/org/switchyard/security/credential/extract/SOAPMessageCredentialsExtractorTests-BinarySecurityToken.xml";

    @Test
    public void testAssertion() throws Exception {
        SOAPMessage source = this.createMessage(ASSERTION_XML);
        Set creds = new SOAPMessageCredentialsExtractor().extractCredentials(source);
        boolean foundAssertion = false;
        for (Credential cred : creds) {
            if (!(cred instanceof AssertionCredential)) continue;
            foundAssertion = true;
            Element assertion = ((AssertionCredential)cred).getAssertion();
            Assert.assertEquals((String)"ID_00cdd057-e611-439d-a189-581e1437e560", (String)assertion.getAttribute("ID"));
        }
        if (!foundAssertion) {
            Assert.fail((String)"assertion not found");
        }
    }

    @Test
    public void testUsernameToken() throws Exception {
        SOAPMessage source = this.createMessage(USERNAME_TOKEN_XML);
        Set creds = new SOAPMessageCredentialsExtractor().extractCredentials(source);
        boolean foundName = false;
        boolean foundPassword = false;
        for (Credential cred : creds) {
            if (cred instanceof NameCredential) {
                foundName = true;
                String name = ((NameCredential)cred).getName();
                Assert.assertEquals((String)"Aladdin", (String)name);
                continue;
            }
            if (!(cred instanceof PasswordCredential)) continue;
            foundPassword = true;
            String password = new String(((PasswordCredential)cred).getPassword());
            Assert.assertEquals((String)"open sesame", (String)password);
        }
        if (!foundName) {
            Assert.fail((String)"name not found");
        }
        if (!foundPassword) {
            Assert.fail((String)"password not found");
        }
    }

    @Test
    public void testBinarySecurityToken() throws Exception {
        SOAPMessage source = this.createMessage(BINARY_SECURITY_TOKEN_XML);
        Set creds = new SOAPMessageCredentialsExtractor().extractCredentials(source);
        boolean foundCertificate = false;
        for (Credential cred : creds) {
            if (!(cred instanceof CertificateCredential)) continue;
            foundCertificate = true;
            Certificate certificate = ((CertificateCredential)cred).getCertificate();
            Assert.assertEquals((String)"X.509", (String)certificate.getType());
        }
        if (!foundCertificate) {
            Assert.fail((String)"certificate not found");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SOAPMessage createMessage(String path) throws Exception {
        InputStream is = Classes.getResourceAsStream((String)path, this.getClass());
        try {
            SOAPMessage sOAPMessage = MessageFactory.newInstance((String)"SOAP 1.1 Protocol").createMessage(null, is);
            return sOAPMessage;
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }
}

