/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.security.callback;

import java.io.IOException;
import java.util.Set;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.jboss.security.auth.callback.ObjectCallback;
import org.switchyard.security.callback.SwitchYardCallbackHandler;
import org.switchyard.security.credential.CertificateCredential;
import org.switchyard.security.credential.Credential;

public class CertificateCallbackHandler
extends SwitchYardCallbackHandler {
    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        String alias = this.getProperty("alias", true);
        String keyPassword = this.getProperty("keyPassword", true);
        Set<Credential> credentials = this.getCredentials();
        if (credentials == null) {
            throw new IllegalStateException("Credentials not set");
        }
        for (Callback cb : callbacks) {
            if (cb instanceof NameCallback) {
                ((NameCallback)cb).setName(alias);
                continue;
            }
            if (cb instanceof PasswordCallback) {
                ((PasswordCallback)cb).setPassword(keyPassword.toCharArray());
                continue;
            }
            if (!(cb instanceof ObjectCallback)) continue;
            for (Credential cred : credentials) {
                if (!(cred instanceof CertificateCredential)) continue;
                ((ObjectCallback)cb).setCredential((Object)((CertificateCredential)cred).getCertificate());
            }
        }
    }
}

