/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.security.credential.extract;

import java.security.Principal;
import java.util.HashSet;
import java.util.Set;
import org.jboss.com.sun.net.httpserver.HttpExchange;
import org.jboss.com.sun.net.httpserver.HttpPrincipal;
import org.switchyard.common.lang.Strings;
import org.switchyard.security.credential.ConfidentialityCredential;
import org.switchyard.security.credential.Credential;
import org.switchyard.security.credential.PrincipalCredential;
import org.switchyard.security.credential.extract.AuthorizationHeaderCredentialsExtractor;
import org.switchyard.security.credential.extract.CredentialsExtractor;

public class HttpExchangeCredentialsExtractor
implements CredentialsExtractor<HttpExchange> {
    @Override
    public Set<Credential> extractCredentials(HttpExchange source) {
        HashSet<Credential> credentials = new HashSet<Credential>();
        if (source != null) {
            int pos;
            HttpPrincipal principal;
            String protocol = source.getProtocol();
            if (protocol != null) {
                credentials.add(new ConfidentialityCredential(protocol.toLowerCase().startsWith("https")));
            }
            if ((principal = source.getPrincipal()) != null) {
                credentials.add(new PrincipalCredential((Principal)principal, true));
            }
            String charsetName = null;
            String contentType = source.getRequestHeaders().getFirst("Content-Type");
            if (contentType != null && (pos = contentType.lastIndexOf("charset=")) > -1) {
                charsetName = Strings.trimToNull((String)contentType.substring(pos + 8, contentType.length()));
            }
            AuthorizationHeaderCredentialsExtractor ahce = charsetName != null ? new AuthorizationHeaderCredentialsExtractor(charsetName) : new AuthorizationHeaderCredentialsExtractor();
            credentials.addAll(ahce.extractCredentials(source.getRequestHeaders().getFirst("Authorization")));
        }
        return credentials;
    }
}

