/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.security.login;

import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.Principal;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Set;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import org.switchyard.common.io.pull.Puller;
import org.switchyard.security.callback.CertificateCallback;
import org.switchyard.security.login.SwitchYardLoginModule;
import org.switchyard.security.principal.User;
import org.switchyard.security.pull.KeyStorePuller;

public class CertificateLoginModule
extends SwitchYardLoginModule {
    private X509Certificate _verifiedCallerCertificate;

    @Override
    public boolean login() throws LoginException {
        Certificate switchyardCertificate;
        NameCallback aliasCallback = new NameCallback("alias");
        CertificateCallback certificateCallback = new CertificateCallback();
        try {
            this.getCallbackHandler().handle(new Callback[]{aliasCallback, certificateCallback});
        }
        catch (IOException ioe) {
            throw new LoginException("Failed to invoke callback: " + ioe.getMessage());
        }
        catch (UnsupportedCallbackException uce) {
            throw new LoginException("CallbackHandler does not support: " + uce.getCallback());
        }
        X509Certificate callerCertificate = this.getCallerCertificate(certificateCallback);
        KeyStore keyStore = this.getKeyStore();
        String alias = aliasCallback.getName();
        try {
            switchyardCertificate = keyStore.getCertificate(alias);
        }
        catch (KeyStoreException kse) {
            throw new LoginException("problem accessing KeyStore: " + kse.getMessage());
        }
        try {
            callerCertificate.verify(switchyardCertificate.getPublicKey());
        }
        catch (Exception e) {
            throw new LoginException("problem verifying caller Certificate: " + e.getMessage());
        }
        this._verifiedCallerCertificate = callerCertificate;
        return true;
    }

    @Override
    public boolean commit() throws LoginException {
        if (this._verifiedCallerCertificate == null) {
            return false;
        }
        Set<Principal> principals = this.getSubject().getPrincipals();
        String name = this._verifiedCallerCertificate.getSubjectX500Principal().getName();
        name = name.substring(name.indexOf(61) + 1, name.indexOf(44));
        User authenticatedPrincipal = new User(name);
        principals.add(authenticatedPrincipal);
        return true;
    }

    @Override
    public boolean logout() throws LoginException {
        this._verifiedCallerCertificate = null;
        return true;
    }

    private X509Certificate getCallerCertificate(CertificateCallback certificateCallback) throws LoginException {
        X509Certificate x509cert = null;
        for (Certificate cert : certificateCallback.getCertificates()) {
            if (!(cert instanceof X509Certificate)) continue;
            x509cert = (X509Certificate)cert;
            break;
        }
        if (x509cert == null) {
            throw new LoginException("no caller X509 Certificate provided");
        }
        return x509cert;
    }

    private KeyStore getKeyStore() throws LoginException {
        String keyStoreLocation = this.getOption("keyStoreLocation", true);
        String keyStoreType = this.getOption("keyStoreType", false);
        String keyStorePassword = this.getOption("keyStorePassword", false);
        KeyStorePuller keyStorePuller = new KeyStorePuller(keyStoreType, keyStorePassword != null ? keyStorePassword.toCharArray() : null);
        return (KeyStore)keyStorePuller.pullPath(keyStoreLocation, this.getClass(), Puller.PathType.values());
    }
}

