/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.security.login;

import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.Principal;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Properties;
import java.util.Set;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import org.switchyard.common.io.pull.PropertiesPuller;
import org.switchyard.common.io.pull.Puller;
import org.switchyard.common.lang.Strings;
import org.switchyard.security.BaseSecurityMessages;
import org.switchyard.security.callback.CertificateCallback;
import org.switchyard.security.login.SwitchYardLoginModule;
import org.switchyard.security.principal.Group;
import org.switchyard.security.principal.Role;
import org.switchyard.security.principal.User;
import org.switchyard.security.pull.KeyStorePuller;

public class CertificateLoginModule
extends SwitchYardLoginModule {
    private X509Certificate _verifiedCallerCertificate;

    @Override
    public boolean login() throws LoginException {
        Certificate switchyardCertificate;
        NameCallback aliasCallback = new NameCallback("alias");
        CertificateCallback certificateCallback = new CertificateCallback();
        try {
            this.getCallbackHandler().handle(new Callback[]{aliasCallback, certificateCallback});
        }
        catch (IOException ioe) {
            throw BaseSecurityMessages.MESSAGES.failedInvokeCallback(ioe.getMessage(), ioe);
        }
        catch (UnsupportedCallbackException uce) {
            throw BaseSecurityMessages.MESSAGES.callbackHandlerNoSupport(uce.getCallback().toString());
        }
        X509Certificate callerCertificate = this.getCallerCertificate(certificateCallback);
        KeyStore keyStore = this.getKeyStore();
        String alias = aliasCallback.getName();
        try {
            switchyardCertificate = keyStore.getCertificate(alias);
        }
        catch (KeyStoreException kse) {
            throw BaseSecurityMessages.MESSAGES.problemAccessingKeystore(kse.getMessage());
        }
        try {
            callerCertificate.verify(switchyardCertificate.getPublicKey());
        }
        catch (Exception e) {
            throw BaseSecurityMessages.MESSAGES.problemVerifyingCallerCert(e.getMessage());
        }
        this._verifiedCallerCertificate = callerCertificate;
        return true;
    }

    @Override
    public boolean commit() throws LoginException {
        if (this._verifiedCallerCertificate == null) {
            return false;
        }
        Set<Principal> principals = this.getSubject().getPrincipals();
        String userName = this._verifiedCallerCertificate.getSubjectX500Principal().getName();
        userName = userName.substring(userName.indexOf(61) + 1, userName.indexOf(44));
        User authenticatedPrincipal = new User(userName);
        principals.add(authenticatedPrincipal);
        Properties rolesProperties = this.getRolesProperties();
        if (rolesProperties != null) {
            Set<Group> groups = this.getSubject().getPrincipals(Group.class);
            Set roleNames = Strings.uniqueSplitTrimToNull((String)rolesProperties.getProperty(userName), (String)",");
            for (String roleName : roleNames) {
                Role role = new Role(roleName);
                if (groups.isEmpty()) {
                    Group rolesGroup = new Group("Roles");
                    rolesGroup.addMember(role);
                    this.getSubject().getPrincipals().add((Principal)((Object)rolesGroup));
                    continue;
                }
                for (Group group : groups) {
                    if (!"Roles".equals(group.getName())) continue;
                    group.addMember(role);
                }
            }
        }
        return true;
    }

    @Override
    public boolean logout() throws LoginException {
        this._verifiedCallerCertificate = null;
        return true;
    }

    private X509Certificate getCallerCertificate(CertificateCallback certificateCallback) throws LoginException {
        X509Certificate x509cert = null;
        for (Certificate cert : certificateCallback.getCertificates()) {
            if (!(cert instanceof X509Certificate)) continue;
            x509cert = (X509Certificate)cert;
            break;
        }
        if (x509cert == null) {
            throw BaseSecurityMessages.MESSAGES.noCallerCertificateProvided();
        }
        return x509cert;
    }

    private KeyStore getKeyStore() throws LoginException {
        String keyStoreLocation = this.getOption("keyStoreLocation", true);
        String keyStoreType = this.getOption("keyStoreType", false);
        String keyStorePassword = this.getOption("keyStorePassword", false);
        KeyStorePuller keyStorePuller = new KeyStorePuller(keyStoreType, keyStorePassword != null ? keyStorePassword.toCharArray() : null);
        return (KeyStore)keyStorePuller.pullPath(keyStoreLocation, this.getClass(), Puller.PathType.values());
    }

    private Properties getRolesProperties() {
        String rolesPropertiesFile = this.getOption("rolesProperties", false);
        if (rolesPropertiesFile != null) {
            return (Properties)new PropertiesPuller().pullPath(rolesPropertiesFile, this.getClass(), Puller.PathType.values());
        }
        return null;
    }
}

