/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.security.principal;

import java.io.Serializable;
import java.security.Principal;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import org.switchyard.security.BaseSecurityMessages;

public class Group
implements java.security.acl.Group,
Serializable {
    private static final long serialVersionUID = -909127780618924905L;
    private static final String FORMAT = Group.class.getSimpleName() + "@%s[name=%s, members=%s]";
    public static final String ROLES = "Roles";
    private final String _name;
    private final Set<Principal> _members = new HashSet<Principal>();

    public Group(String name) {
        if (name == null) {
            throw BaseSecurityMessages.MESSAGES.groupNameCannotBeNull();
        }
        this._name = name;
    }

    public String getName() {
        return this._name;
    }

    public boolean addMember(Principal user) {
        return this._members.add(user);
    }

    public boolean isMember(Principal member) {
        return this._members.contains(member);
    }

    public Enumeration<? extends Principal> members() {
        return Collections.enumeration(this._members);
    }

    public boolean removeMember(Principal user) {
        return this._members.remove(user);
    }

    public String toString() {
        return String.format(FORMAT, System.identityHashCode(this), this._name, this._members);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this._members == null ? 0 : this._members.hashCode());
        result = 31 * result + (this._name == null ? 0 : this._name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Group other = (Group)obj;
        if (this._members == null ? other._members != null : !this._members.equals(other._members)) {
            return false;
        }
        return !(this._name == null ? other._name != null : !this._name.equals(other._name));
    }
}

