/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.security.provider;

import java.security.Principal;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.switchyard.ServiceSecurity;
import org.switchyard.common.lang.Strings;
import org.switchyard.common.type.reflect.Construction;
import org.switchyard.security.BaseSecurityLogger;
import org.switchyard.security.callback.handler.NamePasswordCallbackHandler;
import org.switchyard.security.callback.handler.SwitchYardCallbackHandler;
import org.switchyard.security.context.SecurityContext;
import org.switchyard.security.principal.Group;
import org.switchyard.security.principal.Role;
import org.switchyard.security.provider.SecurityProvider;

public class JaasSecurityProvider
extends SecurityProvider {
    @Override
    public boolean authenticate(ServiceSecurity serviceSecurity, SecurityContext securityContext) {
        CallbackHandler ch;
        boolean success = false;
        Class<NamePasswordCallbackHandler> ch_clazz = serviceSecurity.getCallbackHandler();
        if (ch_clazz == null) {
            ch_clazz = NamePasswordCallbackHandler.class;
        }
        if ((ch = (CallbackHandler)Construction.construct(ch_clazz)) instanceof SwitchYardCallbackHandler) {
            SwitchYardCallbackHandler sych = (SwitchYardCallbackHandler)ch;
            sych.setProperties(serviceSecurity.getProperties());
            sych.setCredentials(securityContext.getCredentials());
        }
        String securityDomain = serviceSecurity.getSecurityDomain();
        Subject subject = securityContext.getSubject(securityDomain);
        try {
            new LoginContext(securityDomain, subject, ch).login();
            success = true;
        }
        catch (LoginException le) {
            BaseSecurityLogger.ROOT_LOGGER.authenticateLoginException(le.getMessage(), le);
        }
        return success;
    }

    @Override
    public boolean propagate(ServiceSecurity serviceSecurity, SecurityContext securityContext) {
        return true;
    }

    @Override
    public boolean addRunAs(ServiceSecurity serviceSecurity, SecurityContext securityContext) {
        boolean success = true;
        String runAs = Strings.trimToNull((String)serviceSecurity.getRunAs());
        if (runAs != null) {
            success = false;
            Role runAsRole = new Role(runAs);
            String securityDomain = serviceSecurity.getSecurityDomain();
            Subject subject = securityContext.getSubject(securityDomain);
            Set<Group> groups = subject.getPrincipals(Group.class);
            if (groups.isEmpty()) {
                Group rolesGroup = new Group("Roles");
                rolesGroup.addMember(runAsRole);
                subject.getPrincipals().add((Principal)((Object)rolesGroup));
                success = true;
            } else {
                for (Group group : groups) {
                    if (!"Roles".equals(group.getName())) continue;
                    group.addMember(runAsRole);
                    success = true;
                }
            }
        }
        return success;
    }

    @Override
    public boolean checkRolesAllowed(ServiceSecurity serviceSecurity, SecurityContext securityContext) {
        Set rolesAllowed = serviceSecurity.getRolesAllowed();
        if (rolesAllowed.isEmpty()) {
            return true;
        }
        String securityDomain = serviceSecurity.getSecurityDomain();
        for (String roleName : rolesAllowed) {
            boolean isInRole = securityContext.isCallerInRole(roleName, securityDomain);
            if (!isInRole) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean clear(ServiceSecurity serviceSecurity, SecurityContext securityContext) {
        String securityDomain;
        if (serviceSecurity != null && (securityDomain = serviceSecurity.getSecurityDomain()) != null) {
            securityContext.clearSubject(securityDomain);
        }
        return true;
    }
}

