/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.security.provider;

import java.util.Iterator;
import java.util.ServiceLoader;
import org.switchyard.ServiceSecurity;
import org.switchyard.security.BaseSecurityLogger;
import org.switchyard.security.context.SecurityContext;
import org.switchyard.security.provider.JaasSecurityProvider;

public abstract class SecurityProvider {
    private static final SecurityProvider INSTANCE;

    public abstract boolean authenticate(ServiceSecurity var1, SecurityContext var2);

    public abstract boolean propagate(ServiceSecurity var1, SecurityContext var2);

    public abstract boolean addRunAs(ServiceSecurity var1, SecurityContext var2);

    public abstract boolean checkRolesAllowed(ServiceSecurity var1, SecurityContext var2);

    public abstract boolean clear(ServiceSecurity var1, SecurityContext var2);

    public static final SecurityProvider instance() {
        return INSTANCE;
    }

    static {
        JaasSecurityProvider instance;
        try {
            ServiceLoader<SecurityProvider> services = ServiceLoader.load(SecurityProvider.class, SecurityProvider.class.getClassLoader());
            Iterator<SecurityProvider> iterator = services.iterator();
            instance = iterator.hasNext() ? iterator.next() : null;
        }
        catch (Throwable t) {
            instance = null;
        }
        INSTANCE = instance != null ? instance : new JaasSecurityProvider();
        BaseSecurityLogger.ROOT_LOGGER.usingSecurityProviderImplementation(INSTANCE.getClass().getName());
    }
}

