/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.test;

import java.lang.reflect.Field;
import org.jboss.logging.Logger;
import org.junit.Assert;
import org.junit.runner.Description;
import org.junit.runner.notification.RunListener;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.InitializationError;
import org.switchyard.test.Invoker;
import org.switchyard.test.ServiceOperation;
import org.switchyard.test.SwitchYardTestKit;
import org.switchyard.test.TestMixIn;

public class SwitchYardRunner
extends BlockJUnit4ClassRunner {
    private static Logger LOG = Logger.getLogger(SwitchYardRunner.class);
    private SwitchYardTestKit _testKit;
    private Object _testInstance;

    public SwitchYardRunner(Class<?> clazz) throws InitializationError {
        super(clazz);
    }

    protected Object createTest() throws Exception {
        this._testInstance = super.createTest();
        this._testKit = new SwitchYardTestKit(this._testInstance);
        for (TestMixIn mixIn : this._testKit.getMixIns()) {
            this.set(mixIn, PropertyMatchResolution.EQUALS);
        }
        try {
            this._testKit.start();
        }
        catch (Throwable t) {
            LOG.error((Object)"Error while test kit startup", t);
            this._testKit.cleanup();
            throw new Exception(t);
        }
        this.set(this._testKit, PropertyMatchResolution.EQUALS);
        this.set(this._testKit.getDeployment(), PropertyMatchResolution.ASSIGNABLE);
        this.set(this._testKit.getConfigModel(), PropertyMatchResolution.ASSIGNABLE);
        this.set(this._testKit.getServiceDomain(), PropertyMatchResolution.ASSIGNABLE);
        this.set(this._testKit.getServiceDomain().getTransformerRegistry(), PropertyMatchResolution.ASSIGNABLE);
        this.set(this._testKit.getServiceDomain().getProperty("CamelContextProperty"), PropertyMatchResolution.ASSIGNABLE);
        this.setInvokers();
        return this._testInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(RunNotifier notifier) {
        TestLifecycleListener listener = new TestLifecycleListener();
        notifier.addListener((RunListener)listener);
        try {
            super.run(notifier);
        }
        finally {
            notifier.removeListener((RunListener)listener);
        }
    }

    private void set(Object propertyValue, PropertyMatchResolution matchRes) throws IllegalAccessException {
        this.set(this._testInstance.getClass(), propertyValue, matchRes);
    }

    private void set(Class<?> clazz, Object propertyValue, PropertyMatchResolution matchRes) throws IllegalAccessException {
        Field[] fields;
        if (Object.class.equals(clazz) || clazz == null) {
            return;
        }
        for (Field field : fields = clazz.getDeclaredFields()) {
            if (!matchRes.matches(field, propertyValue)) continue;
            this.setValue(field, propertyValue);
        }
        this.set(clazz.getSuperclass(), propertyValue, matchRes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setValue(Field field, Object propertyValue) throws IllegalAccessException {
        boolean accessible = field.isAccessible();
        field.setAccessible(true);
        try {
            field.set(this._testInstance, propertyValue);
        }
        finally {
            field.setAccessible(accessible);
        }
    }

    private void setInvokers() throws IllegalAccessException {
        this.setInvokers(this._testInstance.getClass());
    }

    private void setInvokers(Class<?> clazz) throws IllegalAccessException {
        Field[] fields;
        if (Object.class.equals(clazz) || clazz == null) {
            return;
        }
        for (Field field : fields = clazz.getDeclaredFields()) {
            Invoker invoker;
            if (field.getType() != Invoker.class) continue;
            ServiceOperation serviceOp = field.getAnnotation(ServiceOperation.class);
            if (serviceOp == null) {
                Assert.fail((String)("Invoker property '" + field.getName() + "' on test class '" + this._testInstance.getClass().getName() + "' needs to be annotated with a @ServiceOperation."));
            }
            if ((invoker = this._testKit.newInvoker(serviceOp.value())) == null) {
                Assert.fail((String)("Invoker property '" + field.getName() + "' on test class '" + this._testInstance.getClass().getName() + "' contains an a @ServiceOperation defining an unknown Service Operation value '" + serviceOp.value() + "'."));
            }
            this.setValue(field, invoker);
        }
        this.setInvokers(clazz.getSuperclass());
    }

    private static enum PropertyMatchResolution {
        ASSIGNABLE{

            @Override
            public boolean matches(Field field, Object propertyValue) {
                return field.getType().isInstance(propertyValue);
            }
        }
        ,
        EQUALS{

            @Override
            public boolean matches(Field field, Object propertyValue) {
                return field.getType() == propertyValue.getClass();
            }
        };


        public boolean matches(Field field, Object propertyValue) {
            throw new AbstractMethodError();
        }
    }

    private class TestLifecycleListener
    extends RunListener {
        private TestLifecycleListener() {
        }

        public void testFinished(Description description) throws Exception {
            SwitchYardRunner.this._testKit.cleanup();
        }
    }
}

