/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.transform.xslt;

import java.io.Reader;
import java.io.StringWriter;
import javax.xml.namespace.QName;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.switchyard.Message;
import org.switchyard.config.model.Scannable;
import org.switchyard.exception.SwitchYardException;
import org.switchyard.transform.BaseTransformer;

@Scannable(value=false)
public class XsltTransformer<F, T>
extends BaseTransformer<Message, Message> {
    private Templates _templates;

    public XsltTransformer(QName from, QName to, Templates templates) {
        super(from, to);
        this._templates = templates;
    }

    public Message transform(Message message) {
        try {
            StreamSource source = new StreamSource((Reader)message.getContent(Reader.class));
            StringWriter resultWriter = new StringWriter();
            StreamResult result = new StreamResult(resultWriter);
            Transformer transformer = this._templates.newTransformer();
            transformer.transform(source, result);
            message.setContent((Object)resultWriter.toString());
        }
        catch (Exception e) {
            throw new SwitchYardException("Error during xslt transformation", (Throwable)e);
        }
        return message;
    }
}

