/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.transform.jaxb.internal;

import java.io.StringWriter;
import java.io.Writer;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.namespace.QName;
import org.switchyard.Message;
import org.switchyard.common.xml.QNameUtil;
import org.switchyard.config.model.Scannable;
import org.switchyard.exception.SwitchYardException;
import org.switchyard.transform.BaseTransformer;

@Scannable(value=false)
public class JAXBMarshalTransformer<F, T>
extends BaseTransformer<Message, Message> {
    private JAXBContext _jaxbContext;

    public JAXBMarshalTransformer(QName from, QName to, String contextPath) throws SwitchYardException {
        super(from, to);
        try {
            this._jaxbContext = contextPath != null ? JAXBContext.newInstance((String)contextPath) : JAXBContext.newInstance((Class[])new Class[]{QNameUtil.toJavaMessageType((QName)from)});
        }
        catch (JAXBException e) {
            throw new SwitchYardException("Failed to create JAXBContext for '" + from + "'.", (Throwable)e);
        }
    }

    public Message transform(Message message) {
        Marshaller marshaller;
        try {
            marshaller = this._jaxbContext.createMarshaller();
        }
        catch (JAXBException e) {
            throw new SwitchYardException("Failed to create Marshaller for type '" + this.getFrom() + "'.", (Throwable)e);
        }
        try {
            StringWriter resultWriter = new StringWriter();
            Object javaObject = message.getContent();
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            marshaller.marshal(javaObject, (Writer)resultWriter);
            message.setContent((Object)resultWriter.toString());
        }
        catch (JAXBException e) {
            throw new SwitchYardException("Failed to unmarshall for type '" + this.getFrom() + "'.", (Throwable)e);
        }
        return message;
    }
}

