/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.transform.json.internal;

import java.io.IOException;
import java.io.Reader;
import javax.xml.namespace.QName;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;
import org.switchyard.Message;
import org.switchyard.transform.BaseTransformer;
import org.switchyard.transform.TransformMessages;

public class JSON2JavaTransformer<F, T>
extends BaseTransformer<Message, Message> {
    private ObjectMapper _mapper;
    private Class _clazz;

    public JSON2JavaTransformer(QName from, QName to, ObjectMapper mapper, Class clazz) {
        super(from, to);
        this._mapper = mapper;
        this._clazz = clazz;
    }

    public Message transform(Message message) {
        try {
            Object result = this._mapper.readValue((Reader)message.getContent(Reader.class), this._clazz);
            if (this._clazz.isInstance(result)) {
                message.setContent(result);
                return message;
            }
            throw TransformMessages.MESSAGES.transformationResultWrongType(result.getClass().toString());
        }
        catch (JsonParseException e) {
            throw TransformMessages.MESSAGES.unexpectedJSONParseException(e);
        }
        catch (JsonMappingException e) {
            throw TransformMessages.MESSAGES.unexpectedJSONMappingException(e);
        }
        catch (IOException e) {
            throw TransformMessages.MESSAGES.unexpectedIOExceptionCheckTransformer(e);
        }
    }
}

