/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.transform.ootb.lang;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import org.switchyard.annotations.Transformer;
import org.xml.sax.InputSource;

public class NumberTransforms {
    public static final NumberTransforms TRANSFORMER = new NumberTransforms();

    @Transformer
    public String toString(Number number) {
        return number.toString();
    }

    @Transformer
    public Reader toReader(Number number) {
        return new StringReader(number.toString());
    }

    @Transformer
    public InputStream toInputStream(Number number) {
        return new ByteArrayInputStream(number.toString().getBytes());
    }

    @Transformer
    public InputSource toInputSource(Number number) {
        String string = this.toString(number);
        InputSource inputSource = new InputSource();
        inputSource.setByteStream(new ByteArrayInputStream(string.getBytes()));
        inputSource.setCharacterStream(new StringReader(string));
        return inputSource;
    }

    @Transformer
    public char[] toChars(Number number) {
        return this.toString(number).toCharArray();
    }

    @Transformer
    public Character toCharacter(Number number) {
        return Character.valueOf(this.toString(number).charAt(0));
    }

    @Transformer
    public byte[] toBytes(Number number) {
        return this.toString(number).getBytes();
    }
}

