/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.jsbridge.client.loading;

import com.google.gwt.core.client.JavaScriptObject;
import elemental2.promise.Promise;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.enterprise.inject.Instance;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.internal.verification.VerificationModeFactory;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.backend.vfs.Path;
import org.uberfire.backend.vfs.PathFactory;
import org.uberfire.client.mvp.Activity;
import org.uberfire.client.mvp.ActivityBeansCache;
import org.uberfire.client.mvp.ActivityManager;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.mvp.jsbridge.JsWorkbenchLazyActivity;
import org.uberfire.client.promise.Promises;
import org.uberfire.jsbridge.client.loading.ActivityLazyLoaded;
import org.uberfire.jsbridge.client.loading.AppFormerComponentsRegistry;
import org.uberfire.jsbridge.client.loading.AppFormerJsActivityLoader;
import org.uberfire.jsbridge.client.loading.LazyLoadingScreen;
import org.uberfire.jsbridge.client.screen.JsWorkbenchScreenActivity;
import org.uberfire.mocks.EventSourceMock;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.promise.SyncPromises;

@RunWith(value=MockitoJUnitRunner.class)
public class AppFormerJsActivityLoaderTest {
    private AppFormerJsActivityLoader appFormerJsActivityLoader;
    @Mock
    private AppFormerComponentsRegistry appFormerComponentsRegistry;
    @Mock
    private ActivityManager activityManager;
    @Mock
    private EventSourceMock<ActivityLazyLoaded> activityLazyLoadedEvent;
    private SyncPromises promises = new SyncPromises();

    @Before
    public void before() {
        this.appFormerJsActivityLoader = (AppFormerJsActivityLoader)Mockito.spy((Object)new AppFormerJsActivityLoader((Promises)this.promises, this.activityManager, (ActivityBeansCache)Mockito.mock(ActivityBeansCache.class), (PlaceManager)Mockito.mock(PlaceManager.class), (LazyLoadingScreen)Mockito.mock(LazyLoadingScreen.class), this.activityLazyLoadedEvent, (Instance)Mockito.mock(Instance.class), this.appFormerComponentsRegistry));
    }

    @Test
    public void registerComponentPerspective() {
        ((AppFormerJsActivityLoader)Mockito.doNothing().when((Object)this.appFormerJsActivityLoader)).registerPerspective((AppFormerComponentsRegistry.Entry)ArgumentMatchers.any());
        AppFormerComponentsRegistry.Entry entry = this.getEntry("a-perspective", AppFormerComponentsRegistry.Entry.Type.PERSPECTIVE, "bar.js");
        this.appFormerJsActivityLoader.registerComponent(entry);
        ((AppFormerJsActivityLoader)Mockito.verify((Object)this.appFormerJsActivityLoader)).registerPerspective(entry);
    }

    @Test
    public void registerComponentScreen() {
        ((AppFormerJsActivityLoader)Mockito.doNothing().when((Object)this.appFormerJsActivityLoader)).registerScreen((AppFormerComponentsRegistry.Entry)ArgumentMatchers.any());
        AppFormerComponentsRegistry.Entry entry = this.getEntry("a-screen", AppFormerComponentsRegistry.Entry.Type.SCREEN, "bar.js");
        this.appFormerJsActivityLoader.registerComponent(entry);
        ((AppFormerJsActivityLoader)Mockito.verify((Object)this.appFormerJsActivityLoader)).registerScreen(entry);
    }

    @Test
    public void registerComponentEditor() {
        ((AppFormerJsActivityLoader)Mockito.doNothing().when((Object)this.appFormerJsActivityLoader)).registerEditor((AppFormerComponentsRegistry.Entry)ArgumentMatchers.any());
        AppFormerComponentsRegistry.Entry entry = this.getEntry("an-editor", AppFormerComponentsRegistry.Entry.Type.EDITOR, "bar.js");
        this.appFormerJsActivityLoader.registerComponent(entry);
        ((AppFormerJsActivityLoader)Mockito.verify((Object)this.appFormerJsActivityLoader)).registerEditor(entry);
    }

    private AppFormerComponentsRegistry.Entry getEntry(String componentId, AppFormerComponentsRegistry.Entry.Type type, String scriptFileName) {
        AppFormerComponentsRegistry.Entry entry = (AppFormerComponentsRegistry.Entry)Mockito.spy((Object)new AppFormerComponentsRegistry.Entry(componentId, (JavaScriptObject)Mockito.mock(JavaScriptObject.class)));
        ((AppFormerComponentsRegistry.Entry)Mockito.doReturn((Object)type).when((Object)entry)).getType();
        ((AppFormerComponentsRegistry.Entry)Mockito.doReturn((Object)scriptFileName).when((Object)entry)).getSource();
        return entry;
    }

    @Test
    public void init() {
        ((AppFormerComponentsRegistry)Mockito.doReturn((Object)new String[]{"foo", "bar"}).when((Object)this.appFormerComponentsRegistry)).keys();
        ((AppFormerComponentsRegistry)Mockito.doReturn((Object)Mockito.mock(JavaScriptObject.class)).when((Object)this.appFormerComponentsRegistry)).get(ArgumentMatchers.anyString());
        ((AppFormerJsActivityLoader)Mockito.doNothing().when((Object)this.appFormerJsActivityLoader)).registerComponent((AppFormerComponentsRegistry.Entry)ArgumentMatchers.any());
        this.appFormerJsActivityLoader.init("my-module");
        ((AppFormerJsActivityLoader)Mockito.verify((Object)this.appFormerJsActivityLoader, (VerificationMode)VerificationModeFactory.times((int)2))).registerComponent((AppFormerComponentsRegistry.Entry)ArgumentMatchers.any());
    }

    @Test(expected=IllegalArgumentException.class)
    public void onComponentLoaded_unregistered() {
        JavaScriptObject jsObject = (JavaScriptObject)Mockito.mock(JavaScriptObject.class);
        ((AppFormerJsActivityLoader)Mockito.doReturn((Object)"my-component-id").when((Object)this.appFormerJsActivityLoader)).extractComponentId((Object)jsObject);
        this.appFormerJsActivityLoader.onComponentLoaded((Object)jsObject);
    }

    @Test
    public void onComponentLoaded_registeredEditor() {
        AppFormerComponentsRegistry.Entry entry = this.getEntry("my-component-id", AppFormerComponentsRegistry.Entry.Type.EDITOR, "foo.js");
        ((AppFormerJsActivityLoader)Mockito.doReturn((Object)"my-component-id").when((Object)this.appFormerJsActivityLoader)).extractComponentId(ArgumentMatchers.any());
        ((AppFormerJsActivityLoader)Mockito.doNothing().when((Object)this.appFormerJsActivityLoader)).registerEditor(ArgumentMatchers.any(), (String)ArgumentMatchers.eq((Object)"my-component-id"));
        this.appFormerJsActivityLoader.registerEditor(entry);
        this.appFormerJsActivityLoader.onComponentLoaded((Object)entry.getSelf());
        ((AppFormerJsActivityLoader)Mockito.verify((Object)this.appFormerJsActivityLoader)).registerEditor((Object)entry.getSelf(), entry.getComponentId());
    }

    @Test
    public void onComponentLoaded_registeredComponent() {
        AppFormerComponentsRegistry.Entry entry = this.getEntry("my-component-id", AppFormerComponentsRegistry.Entry.Type.SCREEN, "foo.js");
        ((AppFormerJsActivityLoader)Mockito.doReturn((Object)"my-component-id").when((Object)this.appFormerJsActivityLoader)).extractComponentId(ArgumentMatchers.any());
        ((AppFormerJsActivityLoader)Mockito.doNothing().when((Object)this.appFormerJsActivityLoader)).registerScreen(entry);
        ((AppFormerJsActivityLoader)Mockito.doReturn((Object)Mockito.mock(Activity.class)).when((Object)this.appFormerJsActivityLoader)).updateRealContent((JavaScriptObject)ArgumentMatchers.any(), (String)ArgumentMatchers.eq((Object)"my-component-id"));
        this.appFormerJsActivityLoader.registerComponent(entry);
        this.appFormerJsActivityLoader.onComponentLoaded((Object)entry.getSelf());
        ((AppFormerJsActivityLoader)Mockito.verify((Object)this.appFormerJsActivityLoader)).updateRealContent(entry.getSelf(), entry.getComponentId());
        ((EventSourceMock)Mockito.verify(this.activityLazyLoadedEvent)).fire((Object)((ActivityLazyLoaded)ArgumentMatchers.any()));
    }

    @Test(expected=RuntimeException.class)
    public void loadScriptFor_noScript() {
        Mockito.doReturn(Optional.empty()).when((Object)this.appFormerJsActivityLoader.getScriptFileName("my-component-id"));
        this.appFormerJsActivityLoader.loadScriptFor("my-component-id");
    }

    @Test
    public void loadScriptFor_unloaded() {
        this.init();
        ((AppFormerJsActivityLoader)Mockito.doReturn(Optional.of("a-script-path.js")).when((Object)this.appFormerJsActivityLoader)).getScriptFileName("my-component-id");
        ((AppFormerJsActivityLoader)Mockito.doReturn((Object)this.promises.resolve()).when((Object)this.appFormerJsActivityLoader)).loadScript("my-module/a-script-path.js");
        this.appFormerJsActivityLoader.loadScriptFor("my-component-id").catch_(e -> {
            Assert.fail((String)"Promise should've been resolved!");
            return this.promises.resolve();
        });
    }

    @Test
    public void loadScriptFor_loaded() {
        this.loadScriptFor_unloaded();
        ((AppFormerJsActivityLoader)Mockito.verify((Object)this.appFormerJsActivityLoader)).loadScript((String)ArgumentMatchers.any());
        this.appFormerJsActivityLoader.loadScriptFor("my-component-id").catch_(e -> {
            Assert.fail((String)"Promise should've been resolved!");
            return this.promises.resolve();
        });
        ((AppFormerJsActivityLoader)Mockito.verify((Object)this.appFormerJsActivityLoader)).loadScript((String)ArgumentMatchers.any());
    }

    @Test
    public void updateRealContent() {
        JavaScriptObject jsObject = (JavaScriptObject)Mockito.mock(JavaScriptObject.class);
        JsWorkbenchScreenActivity activity = (JsWorkbenchScreenActivity)Mockito.mock(JsWorkbenchScreenActivity.class);
        ((ActivityManager)Mockito.doReturn((Object)activity).when((Object)this.activityManager)).getActivity((PlaceRequest)ArgumentMatchers.any());
        Activity foo = this.appFormerJsActivityLoader.updateRealContent(jsObject, "foo");
        Assert.assertEquals((Object)foo, (Object)activity);
        ((JsWorkbenchLazyActivity)Mockito.verify((Object)((JsWorkbenchLazyActivity)foo))).updateRealContent(jsObject);
    }

    @Test
    public void getScriptFileName_unexistent() {
        Assert.assertEquals(Optional.empty(), (Object)this.appFormerJsActivityLoader.getScriptFileName("my-component"));
    }

    @Test
    public void getScriptFileName_editor() {
        this.appFormerJsActivityLoader.registerEditor(this.getEntry("my-component", AppFormerComponentsRegistry.Entry.Type.EDITOR, "foo.js"));
        Optional scriptFileName = this.appFormerJsActivityLoader.getScriptFileName("my-component");
        Assert.assertTrue((boolean)scriptFileName.isPresent());
        Assert.assertEquals((Object)"foo.js", scriptFileName.get());
    }

    @Test
    public void getScriptFileName_component() {
        ((AppFormerJsActivityLoader)Mockito.doNothing().when((Object)this.appFormerJsActivityLoader)).registerScreen((AppFormerComponentsRegistry.Entry)ArgumentMatchers.any());
        this.appFormerJsActivityLoader.registerComponent(this.getEntry("my-component", AppFormerComponentsRegistry.Entry.Type.SCREEN, "foo.js"));
        Optional scriptFileName = this.appFormerJsActivityLoader.getScriptFileName("my-component");
        Assert.assertTrue((boolean)scriptFileName.isPresent());
        Assert.assertEquals((Object)"foo.js", scriptFileName.get());
    }

    @Test
    public void triggerLoadOfMatchingEditors_nullPath() {
        Assert.assertFalse((boolean)this.appFormerJsActivityLoader.triggerLoadOfMatchingEditors(null, null));
    }

    @Test
    public void triggerLoadOfMatchingEditors_nullPathURI() {
        Assert.assertFalse((boolean)this.appFormerJsActivityLoader.triggerLoadOfMatchingEditors((Path)new PathFactory.PathImpl("foo.txt", null), null));
    }

    @Test
    public void triggerLoadOfMatchingEditors_noMatchingEditors() {
        ((AppFormerJsActivityLoader)Mockito.doReturn(new ArrayList()).when((Object)this.appFormerJsActivityLoader)).loadMatchingEditors("default://foo.txt");
        Assert.assertFalse((boolean)this.appFormerJsActivityLoader.triggerLoadOfMatchingEditors((Path)new PathFactory.PathImpl("foo.txt", "default://foo.txt"), null));
    }

    @Test
    public void triggerLoadOfMatchingEditors_moreThanZeroMatchingEditors() {
        List<Promise> loadingEditors = Collections.singletonList(this.promises.resolve());
        ((AppFormerJsActivityLoader)Mockito.doReturn(loadingEditors).when((Object)this.appFormerJsActivityLoader)).loadMatchingEditors("default://foo.txt");
        ((AppFormerJsActivityLoader)Mockito.doNothing().when((Object)this.appFormerJsActivityLoader)).finishLoadingMatchingEditors((List)ArgumentMatchers.any(), (Runnable)ArgumentMatchers.any());
        Assert.assertTrue((boolean)this.appFormerJsActivityLoader.triggerLoadOfMatchingEditors((Path)new PathFactory.PathImpl("foo.txt", "default://foo.txt"), null));
        ((AppFormerJsActivityLoader)Mockito.verify((Object)this.appFormerJsActivityLoader)).finishLoadingMatchingEditors(loadingEditors, null);
    }

    @Test
    public void finishLoadingMatchingEditors_success() {
        List<Promise> ps = Arrays.asList(this.promises.resolve(), this.promises.resolve());
        AtomicBoolean pass = new AtomicBoolean(false);
        this.appFormerJsActivityLoader.finishLoadingMatchingEditors(ps, () -> pass.set(true));
        Assert.assertTrue((boolean)pass.get());
    }

    @Test
    public void finishLoadingMatchingEditors_failure() {
        List<Promise> ps = Arrays.asList(this.promises.resolve(), this.promises.reject(null));
        this.appFormerJsActivityLoader.finishLoadingMatchingEditors(ps, Assert::fail);
    }

    @Test
    public void loadMatchingEditors_matches() {
        AppFormerComponentsRegistry.Entry entry1 = this.getEntry("my-editor", AppFormerComponentsRegistry.Entry.Type.EDITOR, "foo.js");
        ((AppFormerComponentsRegistry.Entry)Mockito.doReturn((Object)true).when((Object)entry1)).matches("my-asset.txt");
        this.appFormerJsActivityLoader.registerEditor(entry1);
        AppFormerComponentsRegistry.Entry entry2 = this.getEntry("my-other-editor", AppFormerComponentsRegistry.Entry.Type.EDITOR, "foo.js");
        ((AppFormerComponentsRegistry.Entry)Mockito.doReturn((Object)true).when((Object)entry2)).matches("my-asset.txt");
        this.appFormerJsActivityLoader.registerEditor(entry2);
        Promise p1 = this.promises.resolve();
        ((AppFormerJsActivityLoader)Mockito.doReturn((Object)p1).when((Object)this.appFormerJsActivityLoader)).loadScriptFor("my-editor");
        Promise p2 = this.promises.resolve();
        ((AppFormerJsActivityLoader)Mockito.doReturn((Object)p2).when((Object)this.appFormerJsActivityLoader)).loadScriptFor("my-other-editor");
        List promises = this.appFormerJsActivityLoader.loadMatchingEditors("my-asset.txt");
        Assert.assertEquals((long)2L, (long)promises.size());
        Assert.assertSame((Object)p1, promises.get(0));
        Assert.assertSame((Object)p2, promises.get(1));
    }

    @Test
    public void loadMatchingEditors_doesntMatch() {
        AppFormerComponentsRegistry.Entry entry1 = this.getEntry("my-editor", AppFormerComponentsRegistry.Entry.Type.EDITOR, "foo.js");
        ((AppFormerComponentsRegistry.Entry)Mockito.doReturn((Object)false).when((Object)entry1)).matches("my-asset.txt");
        this.appFormerJsActivityLoader.registerEditor(entry1);
        AppFormerComponentsRegistry.Entry entry2 = this.getEntry("my-other-editor", AppFormerComponentsRegistry.Entry.Type.EDITOR, "foo.js");
        ((AppFormerComponentsRegistry.Entry)Mockito.doReturn((Object)true).when((Object)entry2)).matches("my-asset.txt");
        this.appFormerJsActivityLoader.registerEditor(entry2);
        Promise p2 = this.promises.resolve();
        ((AppFormerJsActivityLoader)Mockito.doReturn((Object)p2).when((Object)this.appFormerJsActivityLoader)).loadScriptFor("my-other-editor");
        List promises = this.appFormerJsActivityLoader.loadMatchingEditors("my-asset.txt");
        Assert.assertEquals((long)1L, (long)promises.size());
        Assert.assertSame((Object)p2, promises.get(0));
    }
}

