/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.jsbridge.client.loading;

import com.google.gwt.core.client.JavaScriptObject;
import elemental2.dom.DOMTokenList;
import elemental2.dom.DomGlobal;
import elemental2.dom.HTMLDivElement;
import elemental2.dom.HTMLDocument;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashMap;
import org.jboss.errai.enterprise.client.cdi.api.CDI;
import org.jboss.errai.ioc.client.container.IOC;
import org.jboss.errai.ioc.client.container.SyncBeanDef;
import org.jboss.errai.ioc.client.container.SyncBeanManager;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;
import org.uberfire.backend.vfs.Path;
import org.uberfire.client.mvp.Activity;
import org.uberfire.client.mvp.ActivityBeansCache;
import org.uberfire.client.mvp.ActivityManager;
import org.uberfire.client.mvp.PerspectiveActivity;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.mvp.WorkbenchScreenActivity;
import org.uberfire.client.mvp.jsbridge.JsWorkbenchLazyActivity;
import org.uberfire.client.promise.Promises;
import org.uberfire.client.workbench.Workbench;
import org.uberfire.jsbridge.client.AppFormerJsBridge;
import org.uberfire.jsbridge.client.cdi.SingletonBeanDefinition;
import org.uberfire.jsbridge.client.loading.ActivityLazyLoaded;
import org.uberfire.jsbridge.client.loading.AppFormerComponentsRegistry;
import org.uberfire.jsbridge.client.loading.AppFormerJsActivityLoader;
import org.uberfire.jsbridge.client.loading.JsWorkbenchLazyPerspectiveActivity;
import org.uberfire.jsbridge.client.loading.LazyLoadingScreen;
import org.uberfire.jsbridge.client.perspective.jsnative.JsNativePerspective;
import org.uberfire.jsbridge.client.screen.JsWorkbenchScreenActivity;
import org.uberfire.mocks.EventSourceMock;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.promise.SyncPromises;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={IOC.class, CDI.class, Marshalling.class})
public class AppFormerJsLifecycleIT {
    @Mock
    private ActivityManager activityManager;
    @Mock
    private ActivityBeansCache activityBeansCache;
    @Mock
    private PlaceManager placeManager;
    @Mock
    private TranslationService translationService;
    @Mock
    private LazyLoadingScreen lazyLoadingScreen;
    @Mock
    private EventSourceMock<ActivityLazyLoaded> eventSourceMock;
    @Mock
    private Workbench workbench;
    private SyncPromises promises = new SyncPromises();
    private AppFormerComponentsRegistry registry = (AppFormerComponentsRegistry)Mockito.spy((Object)new AppFormerComponentsRegistry());
    private AppFormerJsActivityLoader appFormerJsActivityLoader;
    private AppFormerJsBridge appFormerJsBridge;

    @Before
    public void before() {
        this.appFormerJsActivityLoader = (AppFormerJsActivityLoader)Mockito.spy((Object)new AppFormerJsActivityLoader((Promises)this.promises, this.activityManager, this.activityBeansCache, this.placeManager, this.lazyLoadingScreen, this.eventSourceMock, null, this.registry));
        this.appFormerJsBridge = (AppFormerJsBridge)Mockito.spy((Object)new AppFormerJsBridge(this.workbench, this.appFormerJsActivityLoader, (Promises)this.promises));
    }

    @Test
    public void testGoTo() {
        ((PlaceManager)Mockito.doNothing().when((Object)this.placeManager)).goTo((PlaceRequest)ArgumentMatchers.any());
        SyncBeanManager beanManager = this.ensureSetupBeanManager();
        this.ensureBeanManagerHas(beanManager, PlaceManager.class, this.placeManager);
        this.appFormerJsBridge.goTo("SomePlace");
        ((PlaceManager)Mockito.verify((Object)this.placeManager)).goTo((PlaceRequest)ArgumentMatchers.any());
    }

    @Test
    public void testGoToPath() {
        ((PlaceManager)Mockito.doNothing().when((Object)this.placeManager)).goTo((Path)ArgumentMatchers.any());
        SyncBeanManager beanManager = this.ensureSetupBeanManager();
        this.ensureBeanManagerHas(beanManager, PlaceManager.class, this.placeManager);
        this.appFormerJsBridge.goToPath("SomeUri");
        ((PlaceManager)Mockito.verify((Object)this.placeManager)).goTo((Path)ArgumentMatchers.any());
    }

    @Test
    public void testFireEvent() {
        PowerMockito.mockStatic(CDI.class, (Class[])new Class[0]);
        PowerMockito.doNothing().when(CDI.class);
        CDI.fireEvent((Object)ArgumentMatchers.any(), (Annotation[])new Annotation[0]);
        PowerMockito.mockStatic(Marshalling.class, (Class[])new Class[0]);
        PowerMockito.when((Object)Marshalling.fromJSON((String)((String)ArgumentMatchers.any()))).thenReturn((Object)"MarshalledEvent");
        this.appFormerJsBridge.fireEvent("{\"foo\": \"bar\"}");
        PowerMockito.verifyStatic(Marshalling.class);
        Marshalling.fromJSON((String)"{\"foo\": \"bar\"}");
        PowerMockito.verifyStatic(CDI.class);
        CDI.fireEvent((Object)"MarshalledEvent", (Annotation[])new Annotation[0]);
    }

    @Test
    public void testTranslate() {
        ((TranslationService)Mockito.doReturn((Object)"translated!").when((Object)this.translationService)).format("key", new Object[0]);
        SyncBeanManager beanManager = this.ensureSetupBeanManager();
        this.ensureBeanManagerHas(beanManager, TranslationService.class, this.translationService);
        String translated = this.appFormerJsBridge.translate("key", (Object[])new String[0]);
        Assert.assertEquals((Object)"translated!", (Object)translated);
        ((TranslationService)Mockito.verify((Object)this.translationService)).format("key", new Object[0]);
    }

    @Test
    public void testInitWithErrorWhileLoadingScripts() {
        this.ensureBridgeWillBeExposed();
        this.ensureScriptWontLoadForModule("ModuleWithError");
        this.appFormerJsBridge.init("ModuleWithError");
        ((Workbench)Mockito.verify((Object)this.workbench)).addStartupBlocker(AppFormerJsBridge.class);
        ((AppFormerJsActivityLoader)Mockito.verify((Object)this.appFormerJsActivityLoader, (VerificationMode)Mockito.never())).init(ArgumentMatchers.anyString());
        ((Workbench)Mockito.verify((Object)this.workbench)).removeStartupBlocker(AppFormerJsBridge.class);
    }

    @Test
    public void testScreenLifecycle() {
        ArgumentCaptor captor = ArgumentCaptor.forClass(SingletonBeanDefinition.class);
        this.ensureComponentIsInAppFormerComponentsRegistry("foo-screen", AppFormerComponentsRegistry.Entry.Type.SCREEN);
        this.ensureDomGlobalCanCreateDivs();
        this.ensureScriptsWillLoadForModule("ScreenTestModule");
        this.ensureBridgeWillBeExposed();
        SyncBeanManager beanManager = this.ensureSetupBeanManager();
        this.appFormerJsBridge.init("ScreenTestModule");
        ((Workbench)Mockito.verify((Object)this.workbench)).addStartupBlocker(AppFormerJsBridge.class);
        ((AppFormerJsActivityLoader)Mockito.verify((Object)this.appFormerJsActivityLoader)).init("ScreenTestModule");
        ((AppFormerJsActivityLoader)Mockito.verify((Object)this.appFormerJsActivityLoader)).registerScreen((AppFormerComponentsRegistry.Entry)ArgumentMatchers.any());
        ((ActivityBeansCache)Mockito.verify((Object)this.activityBeansCache)).addNewScreenActivity((SyncBeanDef)ArgumentMatchers.any());
        ((SyncBeanManager)Mockito.verify((Object)beanManager)).registerBean((SyncBeanDef)captor.capture());
        ((SyncBeanManager)Mockito.verify((Object)beanManager)).registerBeanTypeAlias((SyncBeanDef)ArgumentMatchers.any(), (Class)ArgumentMatchers.eq(WorkbenchScreenActivity.class));
        ((SyncBeanManager)Mockito.verify((Object)beanManager)).registerBeanTypeAlias((SyncBeanDef)ArgumentMatchers.any(), (Class)ArgumentMatchers.eq(JsWorkbenchLazyActivity.class));
        ((SyncBeanManager)Mockito.verify((Object)beanManager)).registerBeanTypeAlias((SyncBeanDef)ArgumentMatchers.any(), (Class)ArgumentMatchers.eq(Activity.class));
        ((Workbench)Mockito.verify((Object)this.workbench)).removeStartupBlocker(AppFormerJsBridge.class);
        JsWorkbenchScreenActivity activity = (JsWorkbenchScreenActivity)Mockito.spy((Object)((SingletonBeanDefinition)captor.getValue()).getInstance());
        JavaScriptObject screenJsObject = this.ensureActivityRepresentsRegisteredComponent((Activity)activity, "foo-screen");
        this.ensureBeanManagerHas(beanManager, AppFormerJsActivityLoader.class, this.appFormerJsActivityLoader);
        this.appFormerJsBridge.registerScreen((Object)screenJsObject);
        ((AppFormerJsActivityLoader)Mockito.verify((Object)this.appFormerJsActivityLoader)).onComponentLoaded((Object)screenJsObject);
        ((JsWorkbenchScreenActivity)Mockito.verify((Object)activity)).updateRealContent(screenJsObject);
        Assert.assertTrue((boolean)activity.isScreenLoaded());
    }

    @Test
    public void testPerspectiveLifecycle() {
        ArgumentCaptor captor = ArgumentCaptor.forClass(SingletonBeanDefinition.class);
        this.ensureComponentIsInAppFormerComponentsRegistry("foo-perspective", AppFormerComponentsRegistry.Entry.Type.PERSPECTIVE);
        this.ensureDomGlobalCanCreateDivs();
        this.ensureScriptsWillLoadForModule("PerspectiveTestModule");
        this.ensureBridgeWillBeExposed();
        SyncBeanManager beanManager = this.ensureSetupBeanManager();
        this.ensureBeanManagerHas(beanManager, ActivityBeansCache.class, this.activityBeansCache);
        this.ensureBeanManagerHas(beanManager, PlaceManager.class, this.placeManager);
        this.ensureBeanManagerHas(beanManager, ActivityManager.class, this.activityManager);
        this.ensureBeanManagerHasBeansForName(beanManager, "foo-perspective");
        this.appFormerJsBridge.init("PerspectiveTestModule");
        ((Workbench)Mockito.verify((Object)this.workbench)).addStartupBlocker(AppFormerJsBridge.class);
        ((AppFormerJsActivityLoader)Mockito.verify((Object)this.appFormerJsActivityLoader)).init("PerspectiveTestModule");
        ((AppFormerJsActivityLoader)Mockito.verify((Object)this.appFormerJsActivityLoader)).registerPerspective((AppFormerComponentsRegistry.Entry)ArgumentMatchers.any());
        ((SyncBeanManager)Mockito.verify((Object)beanManager)).registerBean((SyncBeanDef)captor.capture());
        ((SyncBeanManager)Mockito.verify((Object)beanManager)).registerBeanTypeAlias((SyncBeanDef)ArgumentMatchers.any(), (Class)ArgumentMatchers.eq(PerspectiveActivity.class));
        ((SyncBeanManager)Mockito.verify((Object)beanManager)).registerBeanTypeAlias((SyncBeanDef)ArgumentMatchers.any(), (Class)ArgumentMatchers.eq(JsWorkbenchLazyActivity.class));
        ((SyncBeanManager)Mockito.verify((Object)beanManager)).registerBeanTypeAlias((SyncBeanDef)ArgumentMatchers.any(), (Class)ArgumentMatchers.eq(Activity.class));
        ((ActivityBeansCache)Mockito.verify((Object)this.activityBeansCache)).addNewPerspectiveActivity((SyncBeanDef)ArgumentMatchers.any());
        ((Workbench)Mockito.verify((Object)this.workbench)).removeStartupBlocker(AppFormerJsBridge.class);
        JsWorkbenchLazyPerspectiveActivity activity = (JsWorkbenchLazyPerspectiveActivity)Mockito.spy((Object)((SingletonBeanDefinition)captor.getValue()).getInstance());
        JavaScriptObject screenJsObject = this.ensureActivityRepresentsRegisteredComponent((Activity)activity, "foo-perspective");
        this.ensureBeanManagerHas(beanManager, AppFormerJsActivityLoader.class, this.appFormerJsActivityLoader);
        this.ensurePerspectiveIsNotTemplated(activity);
        this.appFormerJsBridge.registerPerspective((Object)screenJsObject);
        ((AppFormerJsActivityLoader)Mockito.verify((Object)this.appFormerJsActivityLoader)).onComponentLoaded((Object)screenJsObject);
        ((JsWorkbenchLazyPerspectiveActivity)Mockito.verify((Object)activity)).updateRealContent(screenJsObject);
        Assert.assertTrue((boolean)activity.isPerspectiveLoaded());
    }

    @Test
    public void registerEditor() {
        this.ensureComponentIsInAppFormerComponentsRegistry("foo-editor", AppFormerComponentsRegistry.Entry.Type.EDITOR);
        this.ensureDomGlobalCanCreateDivs();
        this.ensureScriptsWillLoadForModule("EditorTestModule");
        this.ensureBridgeWillBeExposed();
        this.appFormerJsBridge.init("EditorTestModule");
        ((Workbench)Mockito.verify((Object)this.workbench)).addStartupBlocker(AppFormerJsBridge.class);
        ((AppFormerJsActivityLoader)Mockito.verify((Object)this.appFormerJsActivityLoader)).init("EditorTestModule");
        ((AppFormerJsActivityLoader)Mockito.verify((Object)this.appFormerJsActivityLoader)).registerEditor((AppFormerComponentsRegistry.Entry)ArgumentMatchers.any());
        Assert.assertTrue((boolean)this.appFormerJsActivityLoader.editors.containsKey("foo-editor"));
        ((Workbench)Mockito.verify((Object)this.workbench)).removeStartupBlocker(AppFormerJsBridge.class);
    }

    private void ensurePerspectiveIsNotTemplated(JsWorkbenchLazyPerspectiveActivity activity) {
        ((JsWorkbenchLazyPerspectiveActivity)Mockito.doReturn((Object)false).when((Object)activity)).isPerspectiveTemplated((JsNativePerspective)ArgumentMatchers.any());
    }

    private void ensureBeanManagerHasBeansForName(SyncBeanManager beanManager, String name) {
        ((SyncBeanManager)Mockito.doReturn(Collections.singletonList((SyncBeanDef)Mockito.mock(SyncBeanDef.class))).when((Object)beanManager)).lookupBeans(name);
    }

    private void ensureBridgeWillBeExposed() {
        ((AppFormerJsBridge)Mockito.doNothing().when((Object)this.appFormerJsBridge)).exposeBridgeAsNativeJs();
    }

    private void ensureScriptsWillLoadForModule(String module) {
        ((AppFormerJsBridge)Mockito.doReturn((Object)this.promises.resolve()).when((Object)this.appFormerJsBridge)).loadAppFormerJsAndReactScripts(module);
    }

    private void ensureScriptWontLoadForModule(String module) {
        ((AppFormerJsBridge)Mockito.doReturn((Object)this.promises.reject(null)).when((Object)this.appFormerJsBridge)).loadAppFormerJsAndReactScripts(module);
    }

    private JavaScriptObject ensureActivityRepresentsRegisteredComponent(Activity activity, String id) {
        JavaScriptObject screenJsObject = (JavaScriptObject)Mockito.mock(JavaScriptObject.class);
        ((AppFormerJsActivityLoader)Mockito.doReturn((Object)id).when((Object)this.appFormerJsActivityLoader)).extractComponentId((Object)screenJsObject);
        ((ActivityManager)Mockito.doReturn((Object)activity).when((Object)this.activityManager)).getActivity((PlaceRequest)ArgumentMatchers.any());
        return screenJsObject;
    }

    private void ensureBeanManagerHas(SyncBeanManager beanManager, Class<?> clazz, Object bean) {
        SyncBeanDef syncBeanDef = (SyncBeanDef)Mockito.mock(SyncBeanDef.class);
        ((SyncBeanDef)Mockito.doReturn((Object)bean).when((Object)syncBeanDef)).getInstance();
        ((SyncBeanManager)Mockito.doReturn((Object)syncBeanDef).when((Object)beanManager)).lookupBean(clazz, new Annotation[0]);
    }

    private void ensureDomGlobalCanCreateDivs() {
        ((HTMLDocument)Mockito.doReturn((Object)this.nativeScreenContainerDiv()).when((Object)this.mockDomGlobalDocument())).createElement((String)ArgumentMatchers.any());
    }

    private SyncBeanManager ensureSetupBeanManager() {
        PowerMockito.mockStatic(IOC.class, (Class[])new Class[0]);
        SyncBeanManager beanManager = (SyncBeanManager)Mockito.mock(SyncBeanManager.class);
        PowerMockito.when((Object)IOC.getBeanManager()).thenReturn((Object)beanManager);
        ((SyncBeanManager)Mockito.doNothing().when((Object)beanManager)).registerBean((SyncBeanDef)ArgumentMatchers.any());
        ((SyncBeanManager)Mockito.doNothing().when((Object)beanManager)).registerBeanTypeAlias((SyncBeanDef)ArgumentMatchers.any(), (Class)ArgumentMatchers.any());
        return beanManager;
    }

    private void ensureComponentIsInAppFormerComponentsRegistry(String id, AppFormerComponentsRegistry.Entry.Type type) {
        ((AppFormerComponentsRegistry)Mockito.doReturn((Object)new String[]{id}).when((Object)this.registry)).keys();
        AppFormerComponentsRegistry.Entry entry = (AppFormerComponentsRegistry.Entry)Mockito.spy((Object)new AppFormerComponentsRegistry.Entry(id, (JavaScriptObject)Mockito.mock(JavaScriptObject.class)));
        ((AppFormerComponentsRegistry.Entry)Mockito.doReturn((Object)type).when((Object)entry)).getType();
        ((AppFormerComponentsRegistry.Entry)Mockito.doReturn((Object)"").when((Object)entry)).getSource();
        ((AppFormerComponentsRegistry.Entry)Mockito.doReturn(new HashMap()).when((Object)entry)).getParams();
        ((AppFormerJsActivityLoader)Mockito.doReturn((Object)entry).when((Object)this.appFormerJsActivityLoader)).newRegistryEntry((String)ArgumentMatchers.eq((Object)id));
    }

    private HTMLDivElement nativeScreenContainerDiv() {
        HTMLDivElement div = (HTMLDivElement)Mockito.mock(HTMLDivElement.class);
        div.classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        return div;
    }

    private HTMLDocument mockDomGlobalDocument() {
        try {
            Field document = DomGlobal.class.getDeclaredField("document");
            document.setAccessible(true);
            Field modifiersField = Field.class.getDeclaredField("modifiers");
            modifiersField.setAccessible(true);
            modifiersField.setInt(document, document.getModifiers() & 0xFFFFFFEF);
            HTMLDocument mock = (HTMLDocument)Mockito.mock(HTMLDocument.class);
            document.set(null, mock);
            return mock;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

