import { Element } from "../core";
import { Screen } from "./Screen";
import { Perspective } from "./Perspective";
import { Portable } from "../marshalling";
/**
 * AppFormer.js public API.
 *
 */
export declare class AppFormer {
    /**
     * Starts an AppFormer instance.
     * @param container
     * The DOM element on which AppFormer will start into
     * @param callback
     * Function to be executed after AppFormer init is complete
     */
    init(container: HTMLElement, callback: () => void): AppFormer;
    /**
     * Registers a Screen component.
     * @param screen
     */
    registerScreen(screen: Screen): void;
    /**
     * Registers a Perspective component
     * @param perspective
     */
    registerPerspective(perspective: Perspective): void;
    /**
     * Renders the component with the corresponding id.
     * @param af_componentId
     * The component id
     * @param args
     * Arbitrary arguments to be used by the component
     */
    goTo(af_componentId: string, args?: Map<string, any>): void;
    /**
     * Translates a bundle key
     * @param tkey
     * The bundle key
     * @param args
     * The arguments to this bundle
     */
    translate(tkey: string, args: string[]): string;
    /**
     * Renders a component.
     * @param element
     * The component to be rendered
     * @param container
     * The DOM element on which the component will be rendered.
     * @param callback
     * Function to be executed after the component is done rendering.
     */
    render(element: Element, container: HTMLElement, callback: () => void): void;
    /**
     * Fires an event using Errai bus.
     * @param obj
     * The event object.
     */
    fireEvent<T>(obj: Portable<T>): void;
    /**
     * Executes an RPC call to an Errai Remote.
     * @param path
     * The Errai bus RPC path
     * @param args
     * The arguments to this RPC
     */
    rpc(path: string, args: Array<Portable<any>>): Promise<string>;
    /**
     * Unrenders a component
     * @param af_componentId
     * The component id.
     */
    close(af_componentId: string): void;
}
