import * as React from "react";
/**
 * Core component. Provides basic low-level lifecycle methods for AppFormer components.
 */
export declare abstract class Component {
    readonly core_componentId: string;
    readonly type: string;
    readonly _container: HTMLElement;
    readonly _components: string[];
    af_isReact: boolean;
    af_hasContext: boolean;
    protected constructor(args: {
        type: string;
        core_componentId: string;
    });
    abstract core_componentRoot(children?: any): Element;
    core_onReady(): void;
    core_onVanished(): void;
}
export declare type Element = React.ReactPortal | React.ReactElement<any> | HTMLElement | string;
