import { Portable } from "./Portable";
/**
 * Serializes a Portable<T> object into an Errai json.
 * @param obj
 */
export declare function marshall<T>(obj: Portable<T>): string | null;
/**
 * Deserializes an Errai json creating a Portable<T> object.
 *
 * @param json
 * The Errai json.
 * @param oracle
 * A map containing fqcns as keys and a function returning an empty Portable<T> associated with that fqcn.
 */
export declare function unmarshall<T>(json: string, oracle: Map<string, () => Portable<any>>): Portable<T> | null | void;
