/*
 * Decompiled with CFR 0.152.
 */
package org.appformer.kogito.bridge.client.stateControl.registry.impl;

import org.appformer.client.stateControl.registry.RegistryChangeListener;
import org.appformer.kogito.bridge.client.stateControl.registry.impl.KogitoCommandRegistry;
import org.appformer.kogito.bridge.client.stateControl.registry.interop.KogitoJSCommandRegistry;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class KogitoCommandRegistryTest {
    private boolean envelopeEnabled = true;
    @Mock
    private RegistryChangeListener registryChangeListener;
    @Mock
    private KogitoJSCommandRegistry<Object> kogitoJSCommandRegistry;
    private KogitoCommandRegistry<Object> commandRegistry;

    @Before
    public void setUp() {
        Mockito.when((Object)this.kogitoJSCommandRegistry.getCommands()).thenReturn((Object)new Object[0]);
        Mockito.when((Object)this.kogitoJSCommandRegistry.pop()).thenReturn(new Object());
        Mockito.when((Object)this.kogitoJSCommandRegistry.peek()).thenReturn(new Object());
        this.commandRegistry = new KogitoCommandRegistry(() -> this.envelopeEnabled, () -> this.kogitoJSCommandRegistry);
        this.commandRegistry.setRegistryChangeListener(this.registryChangeListener);
    }

    @Test
    public void testBuildOutsideEnvelope() {
        this.envelopeEnabled = false;
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new KogitoCommandRegistry(() -> this.envelopeEnabled, () -> this.kogitoJSCommandRegistry)).isInstanceOf(RuntimeException.class)).hasMessage("Envelope isn't present, we shouldn't be here!");
    }

    @Test
    public void testRegisterCommand() {
        this.commandRegistry.register(new Object());
        ((KogitoJSCommandRegistry)Mockito.verify(this.kogitoJSCommandRegistry)).register(Matchers.anyString(), Matchers.anyObject());
        ((RegistryChangeListener)Mockito.verify((Object)this.registryChangeListener)).notifyRegistryChange();
    }

    @Test
    public void testPeek() {
        this.commandRegistry.peek();
        ((KogitoJSCommandRegistry)Mockito.verify(this.kogitoJSCommandRegistry)).peek();
    }

    @Test
    public void testPop() {
        this.commandRegistry.pop();
        ((KogitoJSCommandRegistry)Mockito.verify(this.kogitoJSCommandRegistry)).pop();
        ((RegistryChangeListener)Mockito.verify((Object)this.registryChangeListener)).notifyRegistryChange();
    }

    @Test
    public void testClear() {
        this.commandRegistry.clear();
        ((KogitoJSCommandRegistry)Mockito.verify(this.kogitoJSCommandRegistry)).clear();
        ((RegistryChangeListener)Mockito.verify((Object)this.registryChangeListener)).notifyRegistryChange();
    }

    @Test
    public void testIsEmpty() {
        this.commandRegistry.isEmpty();
        ((KogitoJSCommandRegistry)Mockito.verify(this.kogitoJSCommandRegistry)).isEmpty();
    }

    @Test
    public void testGetCommandsHistory() {
        this.commandRegistry.getHistory();
        ((KogitoJSCommandRegistry)Mockito.verify(this.kogitoJSCommandRegistry)).getCommands();
    }

    @Test
    public void testSetMaxSize() {
        this.commandRegistry.setMaxSize(1);
        ((KogitoJSCommandRegistry)Mockito.verify(this.kogitoJSCommandRegistry)).setMaxSize(Matchers.eq((int)1));
    }

    @Test
    public void testSettingWrongMaxSize() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.commandRegistry.setMaxSize(-1)).isInstanceOf(IllegalArgumentException.class)).hasMessage("The registry size should be a positive number");
    }
}

