/*
 * Decompiled with CFR 0.152.
 */
package org.appformer.kogito.bridge.client.guided.tour;

import java.util.Arrays;
import java.util.Collections;
import org.appformer.kogito.bridge.client.guided.tour.GuidedTourBridge;
import org.appformer.kogito.bridge.client.guided.tour.GuidedTourCustomSelectorPositionProvider;
import org.appformer.kogito.bridge.client.guided.tour.GuidedTourObserver;
import org.appformer.kogito.bridge.client.guided.tour.observers.GlobalHTMLObserver;
import org.appformer.kogito.bridge.client.guided.tour.service.GuidedTourService;
import org.appformer.kogito.bridge.client.guided.tour.service.api.Tutorial;
import org.appformer.kogito.bridge.client.guided.tour.service.api.UserInteraction;
import org.jboss.errai.ioc.client.api.Disposer;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class GuidedTourBridgeTest {
    @Mock
    private GuidedTourService service;
    @Mock
    private GlobalHTMLObserverFake observer;
    private GuidedTourBridge bridge;

    @Before
    public void setup() {
        this.bridge = (GuidedTourBridge)Mockito.spy((Object)new GuidedTourBridge(this.service, (GlobalHTMLObserver)this.observer));
        this.bridge.init();
    }

    @Test
    public void testInit() {
        Assert.assertEquals(Collections.singletonList(this.observer), (Object)this.bridge.observers);
    }

    @Test
    public void testRefresh() {
        UserInteraction userInteraction = (UserInteraction)Mockito.mock(UserInteraction.class);
        Mockito.when((Object)this.service.isEnabled()).thenReturn((Object)true);
        this.bridge.refresh(userInteraction);
        ((GuidedTourService)Mockito.verify((Object)this.service)).refresh(userInteraction);
    }

    @Test
    public void testRegisterTutorial() {
        Tutorial tutorial = (Tutorial)Mockito.mock(Tutorial.class);
        Mockito.when((Object)this.service.isEnabled()).thenReturn((Object)true);
        this.bridge.registerTutorial(tutorial);
        ((GuidedTourService)Mockito.verify((Object)this.service)).registerTutorial(tutorial);
    }

    @Test
    public void testRefreshWhenBridgeIsNotEnabled() {
        UserInteraction userInteraction = (UserInteraction)Mockito.mock(UserInteraction.class);
        Mockito.when((Object)this.service.isEnabled()).thenReturn((Object)false);
        this.bridge.refresh(userInteraction);
        ((GlobalHTMLObserverFake)((Object)Mockito.verify((Object)((Object)this.observer)))).dispose();
    }

    @Test
    public void testRegisterTutorialWhenBridgeIsNotEnabled() {
        Tutorial tutorial = (Tutorial)Mockito.mock(Tutorial.class);
        Mockito.when((Object)this.service.isEnabled()).thenReturn((Object)false);
        this.bridge.registerTutorial(tutorial);
        ((GlobalHTMLObserverFake)((Object)Mockito.verify((Object)((Object)this.observer)))).dispose();
    }

    @Test
    public void testRegisterObserver() {
        GuidedTourObserver observer = (GuidedTourObserver)Mockito.mock(GuidedTourObserver.class);
        this.bridge.registerObserver(observer);
        ((GuidedTourObserver)Mockito.verify((Object)observer)).setMonitorBridge(this.bridge);
        Assert.assertEquals(Arrays.asList(new GuidedTourObserver[]{this.observer, observer}), (Object)this.bridge.observers);
    }

    @Test
    public void testRegisterPositionProvider() {
        GuidedTourCustomSelectorPositionProvider positionProvider = (GuidedTourCustomSelectorPositionProvider)Mockito.mock(GuidedTourCustomSelectorPositionProvider.class);
        GuidedTourCustomSelectorPositionProvider.PositionProviderFunction positionProviderFunction = (GuidedTourCustomSelectorPositionProvider.PositionProviderFunction)Mockito.mock(GuidedTourCustomSelectorPositionProvider.PositionProviderFunction.class);
        String type = "type";
        ((GuidedTourBridge)Mockito.doReturn((Object)positionProvider).when((Object)this.bridge)).getPositionProviderInstance();
        this.bridge.registerPositionProvider("type", positionProviderFunction);
        ((GuidedTourCustomSelectorPositionProvider)Mockito.verify((Object)positionProvider)).registerPositionProvider("type", positionProviderFunction);
    }

    class GlobalHTMLObserverFake
    extends GlobalHTMLObserver {
        GlobalHTMLObserverFake(Disposer<GlobalHTMLObserver> selfDisposer) {
            super(selfDisposer);
        }

        protected void dispose() {
            super.dispose();
        }
    }
}

