/*
 * Decompiled with CFR 0.152.
 */
package org.appformer.kogito.bridge.client.guided.tour.service;

import com.google.gwtmockito.GwtMockitoTestRunner;
import org.appformer.kogito.bridge.client.guided.tour.service.GuidedTourServiceEnvelope;
import org.appformer.kogito.bridge.client.guided.tour.service.GuidedTourServiceNativeEnvelope;
import org.appformer.kogito.bridge.client.guided.tour.service.api.Tutorial;
import org.appformer.kogito.bridge.client.guided.tour.service.api.UserInteraction;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;

@RunWith(value=GwtMockitoTestRunner.class)
public class GuidedTourServiceEnvelopeTest {
    private GuidedTourServiceEnvelope envelope;
    @Mock
    private GuidedTourServiceNativeEnvelope nativeEnvelope;

    @Before
    public void setup() {
        this.envelope = (GuidedTourServiceEnvelope)Mockito.spy((Object)new GuidedTourServiceEnvelope());
        ((GuidedTourServiceEnvelope)Mockito.doReturn((Object)this.nativeEnvelope).when((Object)this.envelope)).getNativeEnvelope();
    }

    @Test
    public void testRefresh() {
        UserInteraction userInteraction = (UserInteraction)Mockito.mock(UserInteraction.class);
        this.envelope.refresh(userInteraction);
        ((GuidedTourServiceNativeEnvelope)Mockito.verify((Object)this.nativeEnvelope)).refresh(userInteraction);
    }

    @Test
    public void testRegisterTutorial() {
        Tutorial tutorial = (Tutorial)Mockito.mock(Tutorial.class);
        this.envelope.registerTutorial(tutorial);
        ((GuidedTourServiceNativeEnvelope)Mockito.verify((Object)this.nativeEnvelope)).registerTutorial(tutorial);
    }

    @Test
    public void testIsEnabledWhenItReturnsTrue() {
        Mockito.when((Object)this.nativeEnvelope.isEnabled()).thenReturn((Object)true);
        Assert.assertTrue((boolean)this.envelope.isEnabled());
    }

    @Test
    public void testIsEnabledWhenItReturnsFalse() {
        Mockito.when((Object)this.nativeEnvelope.isEnabled()).thenReturn((Object)false);
        Assert.assertFalse((boolean)this.envelope.isEnabled());
    }
}

