/*
 * Decompiled with CFR 0.152.
 */
package org.appformer.kogito.bridge.client.pmmleditor.marshaller;

import elemental2.dom.Console;
import elemental2.dom.DomGlobal;
import org.appformer.kogito.bridge.client.pmmleditor.marshaller.PMMLEditorMarshallerService;
import org.appformer.kogito.bridge.client.pmmleditor.marshaller.PMMLEditorMarshallerServiceProducer;
import org.appformer.kogito.bridge.client.pmmleditor.marshaller.UnavailablePMMLEditorMarshallerService;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class PMMLEditorMarshallerServiceProducerTest {
    @Mock
    private Console console;
    private PMMLEditorMarshallerServiceProducer producer;

    @Before
    public void setup() {
        this.producer = (PMMLEditorMarshallerServiceProducer)Mockito.spy((Object)new PMMLEditorMarshallerServiceProducer());
        DomGlobal.console = this.console;
    }

    @Test
    public void produceWithEnvelopeAvailable() {
        ((PMMLEditorMarshallerServiceProducer)Mockito.doReturn((Object)true).when((Object)this.producer)).isEnvelopeAvailable();
        ((ObjectAssert)Assertions.assertThat((Object)this.producer.produce()).isNotNull()).isInstanceOf(PMMLEditorMarshallerService.class);
    }

    @Test
    public void produceWithEnvelopeNotAvailable() {
        ((PMMLEditorMarshallerServiceProducer)Mockito.doReturn((Object)false).when((Object)this.producer)).isEnvelopeAvailable();
        ((ObjectAssert)Assertions.assertThat((Object)this.producer.produce()).isNotNull()).isInstanceOf(UnavailablePMMLEditorMarshallerService.class);
        ((Console)Mockito.verify((Object)this.console)).warn(new Object[]{"[PMMLEditorMarshallerApi] Envelope API is not available. Empty PMML models will be passed"});
    }
}

