/*
 * Decompiled with CFR 0.152.
 */
package org.appformer.kogito.bridge.client.guided.tour;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.appformer.kogito.bridge.client.guided.tour.GuidedTourCustomSelectorPositionProvider;
import org.appformer.kogito.bridge.client.guided.tour.GuidedTourObserver;
import org.appformer.kogito.bridge.client.guided.tour.observers.GlobalHTMLObserver;
import org.appformer.kogito.bridge.client.guided.tour.service.GuidedTourService;
import org.appformer.kogito.bridge.client.guided.tour.service.api.Tutorial;
import org.appformer.kogito.bridge.client.guided.tour.service.api.UserInteraction;

@ApplicationScoped
public class GuidedTourBridge {
    private final GuidedTourService guidedTourService;
    private final GlobalHTMLObserver globalHTMLObserver;
    List<GuidedTourObserver> observers = new ArrayList<GuidedTourObserver>();

    @Inject
    public GuidedTourBridge(GuidedTourService guidedTourService, GlobalHTMLObserver globalHTMLObserver) {
        this.guidedTourService = guidedTourService;
        this.globalHTMLObserver = globalHTMLObserver;
    }

    @PostConstruct
    public void init() {
        this.registerObserver(this.globalHTMLObserver);
    }

    public void refresh(UserInteraction userInteraction) {
        this.getGuidedTourService().refresh(userInteraction);
    }

    public void registerTutorial(Tutorial tutorial) {
        this.getGuidedTourService().registerTutorial(tutorial);
    }

    public void registerObserver(GuidedTourObserver observer) {
        observer.setMonitorBridge(this);
        this.observers.add(observer);
    }

    public void registerPositionProvider(String type, GuidedTourCustomSelectorPositionProvider.PositionProviderFunction positionProviderFunction) {
        this.getPositionProviderInstance().registerPositionProvider(type, positionProviderFunction);
    }

    private GuidedTourService getGuidedTourService() {
        if (this.guidedTourService.isEnabled()) {
            return this.guidedTourService;
        }
        this.disposeObservers();
        return GuidedTourService.DEFAULT;
    }

    private void disposeObservers() {
        this.observers.forEach(GuidedTourObserver::dispose);
    }

    GuidedTourCustomSelectorPositionProvider getPositionProviderInstance() {
        return GuidedTourCustomSelectorPositionProvider.getInstance();
    }
}

