/*
 * Decompiled with CFR 0.152.
 */
package org.appformer.kogito.bridge.client.guided.tour;

import elemental2.dom.DomGlobal;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import jsinterop.annotations.JsFunction;
import jsinterop.annotations.JsType;
import org.appformer.kogito.bridge.client.guided.tour.service.api.Rect;

@JsType(namespace="<global>", name="JsInterop__Envelope__GuidedTour__GuidedTourCustomSelectorPositionProvider")
public class GuidedTourCustomSelectorPositionProvider {
    private static GuidedTourCustomSelectorPositionProvider instance;
    private Map<String, PositionProviderFunction> providers = new HashMap<String, PositionProviderFunction>();

    private GuidedTourCustomSelectorPositionProvider() {
    }

    public static GuidedTourCustomSelectorPositionProvider getInstance() {
        if (instance == null) {
            instance = new GuidedTourCustomSelectorPositionProvider();
        }
        return instance;
    }

    public Rect getPosition(String querySelector) {
        boolean isValidQuerySelector;
        String[] querySelectorParts = this.getQuerySelectorParts(querySelector);
        boolean bl = isValidQuerySelector = querySelectorParts.length == 2;
        if (isValidQuerySelector) {
            String type = querySelectorParts[0];
            String selector = querySelectorParts[1];
            Optional<PositionProviderFunction> positionProvider = Optional.ofNullable(this.providers.get(type));
            if (positionProvider.isPresent()) {
                return positionProvider.get().call(selector);
            }
            DomGlobal.console.warn(new Object[]{"[Guided Tour - Position Provider] The position provider could not be found: " + type});
        } else {
            DomGlobal.console.warn(new Object[]{"[Guided Tour - Position Provider] Invalid custom query selector: " + querySelector});
        }
        return this.none();
    }

    Rect none() {
        return Rect.NONE();
    }

    public void registerPositionProvider(String type, PositionProviderFunction positionProviderFunction) {
        this.providers.put(type, positionProviderFunction);
    }

    private String[] getQuerySelectorParts(String selector) {
        if (selector == null) {
            return new String[0];
        }
        String separator = ":::";
        return selector.split(":::");
    }

    @JsFunction
    public static interface PositionProviderFunction {
        public Rect call(String var1);
    }
}

