/*
 * Decompiled with CFR 0.152.
 */
package org.appformer.kogito.bridge.client.guided.tour;

import com.google.gwtmockito.GwtMockitoTestRunner;
import elemental2.dom.Console;
import elemental2.dom.DomGlobal;
import java.util.Objects;
import org.appformer.kogito.bridge.client.guided.tour.GuidedTourCustomSelectorPositionProvider;
import org.appformer.kogito.bridge.client.guided.tour.service.api.Rect;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;

@RunWith(value=GwtMockitoTestRunner.class)
public class GuidedTourCustomSelectorPositionProviderTest {
    @Mock
    private Console console;
    private Rect none;
    private GuidedTourCustomSelectorPositionProvider positionProvider;

    @Before
    public void setup() {
        this.positionProvider = (GuidedTourCustomSelectorPositionProvider)Mockito.spy((Object)GuidedTourCustomSelectorPositionProvider.getInstance());
        this.none = this.makeRect(0);
        DomGlobal.console = this.console;
        ((GuidedTourCustomSelectorPositionProvider)Mockito.doReturn((Object)this.none).when((Object)this.positionProvider)).none();
    }

    @Test
    public void testGetPosition() {
        Rect rect1 = this.makeRect(1);
        Rect rect2 = this.makeRect(2);
        this.positionProvider.registerPositionProvider("TEST_PROVIDER_1", name -> Objects.equals(name, "OBJECT-1") ? rect1 : rect2);
        Assert.assertEquals((Object)rect1, (Object)this.positionProvider.getPosition("TEST_PROVIDER_1:::OBJECT-1"));
        Assert.assertEquals((Object)rect2, (Object)this.positionProvider.getPosition("TEST_PROVIDER_1:::OBJECT-2"));
    }

    @Test
    public void testGetPositionWhenSelectorIsInvalid() {
        Rect rect1 = this.makeRect(1);
        Rect rect2 = this.makeRect(2);
        this.positionProvider.registerPositionProvider("TEST_PROVIDER_2", name -> Objects.equals(name, "OBJECT-1") ? rect1 : rect2);
        Rect position = this.positionProvider.getPosition("TEST_PROVIDER_2___OBJECT-1");
        ((Console)Mockito.verify((Object)this.console)).warn(new Object[]{"[Guided Tour - Position Provider] Invalid custom query selector: TEST_PROVIDER_2___OBJECT-1"});
        Assert.assertEquals((Object)this.none, (Object)position);
    }

    @Test
    public void testGetPositionWhenNoSelectorIsRegistered() {
        Rect position = this.positionProvider.getPosition("TEST_PROVIDER_3:::OBJECT-1");
        ((Console)Mockito.verify((Object)this.console)).warn(new Object[]{"[Guided Tour - Position Provider] The position provider could not be found: TEST_PROVIDER_3"});
        Assert.assertEquals((Object)this.none, (Object)position);
    }

    @Test
    public void testGetPositionWhenSelectorIsNull() {
        Rect position = this.positionProvider.getPosition(null);
        ((Console)Mockito.verify((Object)this.console)).warn(new Object[]{"[Guided Tour - Position Provider] Invalid custom query selector: null"});
        Assert.assertEquals((Object)this.none, (Object)position);
    }

    private Rect makeRect(int seed) {
        Rect rect = new Rect();
        rect.setBottom(seed);
        rect.setHeight(seed);
        rect.setLeft(seed);
        rect.setRight(seed);
        rect.setTop(seed);
        rect.setWidth(seed);
        rect.setX(seed);
        rect.setY(seed);
        return rect;
    }
}

