/*
 * Decompiled with CFR 0.152.
 */
package org.appformer.kogito.bridge.client.guided.tour.observers;

import com.google.gwtmockito.GwtMockitoTestRunner;
import elemental2.dom.Attr;
import elemental2.dom.DOMTokenList;
import elemental2.dom.Event;
import elemental2.dom.HTMLDocument;
import elemental2.dom.HTMLElement;
import elemental2.dom.NamedNodeMap;
import java.util.Arrays;
import java.util.List;
import org.appformer.kogito.bridge.client.guided.tour.GuidedTourBridge;
import org.appformer.kogito.bridge.client.guided.tour.GuidedTourObserver;
import org.appformer.kogito.bridge.client.guided.tour.observers.GlobalHTMLObserver;
import org.appformer.kogito.bridge.client.guided.tour.service.GuidedTourService;
import org.appformer.kogito.bridge.client.guided.tour.service.api.UserInteraction;
import org.jboss.errai.ioc.client.api.Disposer;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;

@RunWith(value=GwtMockitoTestRunner.class)
public class GlobalHTMLObserverTest {
    @Mock
    private Disposer<GlobalHTMLObserver> selfDisposer;
    @Mock
    private HTMLDocument document;
    @Mock
    private GuidedTourService service;
    @Mock
    private GlobalHTMLObserver observer;
    @Captor
    private ArgumentCaptor<UserInteraction> userInteractionArgumentCaptor;
    private GuidedTourBridge bridge;
    private GlobalHTMLObserver htmlObserver;

    @Before
    public void setup() {
        this.bridge = (GuidedTourBridge)Mockito.spy((Object)new GuidedTourBridge(this.service, this.observer));
        this.htmlObserver = (GlobalHTMLObserver)Mockito.spy((Object)new GlobalHTMLObserver(this.selfDisposer));
        ((GlobalHTMLObserver)Mockito.doReturn((Object)this.document).when((Object)this.htmlObserver)).document();
        this.htmlObserver.init();
        this.bridge.registerObserver((GuidedTourObserver)this.htmlObserver);
    }

    @Test
    public void testInit() {
        this.document.addEventListener("click", this.htmlObserver.CLICK_LISTENER);
    }

    @Test
    public void testDispose() {
        this.htmlObserver.dispose();
        this.document.removeEventListener("click", this.htmlObserver.CLICK_LISTENER);
    }

    @Test
    public void testOnHTMLElementEvent() {
        Event event = (Event)Mockito.mock(Event.class);
        HTMLElement htmlElement = (HTMLElement)Mockito.mock(HTMLElement.class);
        DOMTokenList classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        UserInteraction expected = (UserInteraction)Mockito.mock(UserInteraction.class);
        List<String> classStringList = Arrays.asList("pf-label", "pf-label--red", "pf-label--xl");
        NamedNodeMap attrNamedNodeMap = (NamedNodeMap)Mockito.spy((Object)new NamedNodeMap());
        Attr node1 = new Attr();
        Attr node2 = new Attr();
        htmlElement.id = "user-name-label";
        htmlElement.tagName = "div";
        htmlElement.classList = classList;
        htmlElement.attributes = attrNamedNodeMap;
        event.target = htmlElement;
        classList.length = classStringList.size();
        attrNamedNodeMap.length = 2;
        node1.nodeName = "data-field";
        node1.nodeValue = "username";
        node2.nodeName = "data-key";
        node2.nodeValue = "123";
        Mockito.when((Object)classList.asList()).thenReturn(classStringList);
        ((NamedNodeMap)Mockito.doReturn((Object)node1).when((Object)attrNamedNodeMap)).item(0);
        ((NamedNodeMap)Mockito.doReturn((Object)node2).when((Object)attrNamedNodeMap)).item(1);
        ((GlobalHTMLObserver)Mockito.doReturn((Object)expected).when((Object)this.htmlObserver)).makeUserInteraction("CLICK", "div[data-field=\"username\"][data-key=\"123\"]#user-name-label.pf-label.pf-label--red.pf-label--xl");
        this.htmlObserver.onHTMLElementEvent(event);
        ((GuidedTourBridge)Mockito.verify((Object)this.bridge)).refresh((UserInteraction)this.userInteractionArgumentCaptor.capture());
        UserInteraction actual = (UserInteraction)this.userInteractionArgumentCaptor.getValue();
        Assert.assertEquals((Object)expected, (Object)actual);
    }
}

