/*
 * Decompiled with CFR 0.152.
 */
package org.appformer.kogito.bridge.client.guided.tour.service;

import com.google.gwtmockito.GwtMockitoTestRunner;
import elemental2.dom.Console;
import elemental2.dom.DomGlobal;
import org.appformer.kogito.bridge.client.guided.tour.service.GuidedTourService;
import org.appformer.kogito.bridge.client.guided.tour.service.GuidedTourServiceProducer;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;

@RunWith(value=GwtMockitoTestRunner.class)
public class GuidedTourServiceProducerTest {
    private GuidedTourServiceProducer producer;
    @Mock
    private Console console;

    @Before
    public void setup() {
        this.producer = (GuidedTourServiceProducer)Mockito.spy((Object)new GuidedTourServiceProducer());
        DomGlobal.console = this.console;
    }

    @Test
    public void testProduceWhenEnvelopeIsAvailable() {
        ((GuidedTourServiceProducer)Mockito.doReturn((Object)true).when((Object)this.producer)).isEnvelopeAvailable();
        GuidedTourService guidedTourService = this.producer.produce();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.console});
        Assert.assertNotNull((Object)guidedTourService);
        Assert.assertNotEquals((Object)GuidedTourService.DEFAULT, (Object)guidedTourService);
    }

    @Test
    public void testProduceWhenEnvelopeIsNotAvailable() {
        ((GuidedTourServiceProducer)Mockito.doReturn((Object)false).when((Object)this.producer)).isEnvelopeAvailable();
        GuidedTourService guidedTourService = this.producer.produce();
        ((Console)Mockito.verify((Object)this.console)).info(new Object[]{"[GuidedTourServiceProducer] Envelope API is not available."});
        Assert.assertNotNull((Object)guidedTourService);
        Assert.assertEquals((Object)GuidedTourService.DEFAULT, (Object)guidedTourService);
    }
}

