/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.security.server;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.uberfire.commons.util.Preconditions;
import org.uberfire.commons.util.PreconditionsServer;
import org.uberfire.security.Resource;
import org.uberfire.security.ResourceManager;
import org.uberfire.security.Role;
import org.uberfire.security.server.URLResource;
import org.uberfire.security.server.util.AntPathMatcher;
import org.yaml.snakeyaml.Yaml;

public class URLResourceManager
implements ResourceManager {
    private static final AntPathMatcher ANT_PATH_MATCHER = new AntPathMatcher();
    private static final Collection<Class<? extends Resource>> SUPPORTED_TYPES = new ArrayList<Class<? extends Resource>>(1){
        {
            this.add(URLResource.class);
        }
    };
    private static final String DEFAULT_CONFIG = "exclude:\n   - /*.ico\n   - /image/**\n   - /css/**";
    private String configFile = "url_filter.yaml";
    private final Resources resources;
    private final Set<String> excludeCache = new HashSet<String>();

    public URLResourceManager(String configFile) {
        if (configFile != null && !configFile.isEmpty()) {
            this.configFile = configFile;
        }
        this.resources = this.loadConfigData();
    }

    private Resources loadConfigData() {
        Yaml yaml = new Yaml();
        InputStream stream = URLResourceManager.class.getClassLoader().getResourceAsStream(this.configFile);
        Map result = stream != null ? (Map)yaml.loadAs(stream, Map.class) : (Map)yaml.loadAs(DEFAULT_CONFIG, Map.class);
        return new Resources(result);
    }

    public boolean supports(Resource resource) {
        return resource instanceof URLResource;
    }

    public boolean requiresAuthentication(Resource resource) {
        URLResource urlResource;
        try {
            urlResource = (URLResource)PreconditionsServer.checkInstanceOf((String)"context", (Object)resource, URLResource.class);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        if (!this.excludeCache.contains(urlResource.getURL())) {
            boolean isExcluded = false;
            for (String excluded : this.resources.getExcludedResources()) {
                if (!ANT_PATH_MATCHER.match(excluded, urlResource.getURL())) continue;
                isExcluded = true;
                this.excludeCache.add(urlResource.getURL());
                break;
            }
            return !isExcluded;
        }
        return false;
    }

    public List<Role> getMandatoryRoles(URLResource urlResource) {
        for (Map.Entry<String, List<Role>> activeFilteredResource : this.resources.getMandatoryFilteredResources().entrySet()) {
            if (!ANT_PATH_MATCHER.match(activeFilteredResource.getKey(), urlResource.getURL())) continue;
            return activeFilteredResource.getValue();
        }
        return Collections.emptyList();
    }

    private static class Resources {
        private final Map<String, List<Role>> filteredResources;
        private final Map<String, List<Role>> mandatoryFilteredResources;
        private final Set<String> excludedResources;

        private Resources(Map yaml) {
            Preconditions.checkNotNull((String)"yaml", (Object)yaml);
            Object ofilter = yaml.get("filter");
            if (ofilter != null) {
                List filter = (List)PreconditionsServer.checkInstanceOf((String)"ofilter", ofilter, List.class);
                this.filteredResources = new HashMap<String, List<Role>>(filter.size());
                this.mandatoryFilteredResources = new HashMap<String, List<Role>>(filter.size());
                for (Map activeFilter : filter) {
                    List roles;
                    String pattern = (String)activeFilter.get("pattern");
                    String access = (String)activeFilter.get("access");
                    Preconditions.checkNotNull((String)"pattern", (Object)pattern);
                    if (access != null) {
                        String[] textRoles = access.split(",");
                        roles = new ArrayList(textRoles.length);
                        for (final String textRole : textRoles) {
                            roles.add(new Role(){

                                public String getName() {
                                    return textRole;
                                }
                            });
                        }
                        this.mandatoryFilteredResources.put(pattern, roles);
                    } else {
                        roles = Collections.emptyList();
                    }
                    this.filteredResources.put(pattern, roles);
                }
            } else {
                this.filteredResources = Collections.emptyMap();
                this.mandatoryFilteredResources = Collections.emptyMap();
            }
            Object oexclude = yaml.get("exclude");
            List exclude = (List)PreconditionsServer.checkInstanceOf((String)"exclude", oexclude, List.class);
            this.excludedResources = new HashSet<String>(exclude);
        }

        public Map<String, List<Role>> getFilteredResources() {
            return this.filteredResources;
        }

        public Set<String> getExcludedResources() {
            return this.excludedResources;
        }

        public Map<String, List<Role>> getMandatoryFilteredResources() {
            return this.mandatoryFilteredResources;
        }
    }
}

