/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.security.server.auth.source;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.uberfire.commons.util.PreconditionsServer;
import org.uberfire.security.Role;
import org.uberfire.security.auth.AuthenticationSource;
import org.uberfire.security.auth.Credential;
import org.uberfire.security.auth.Principal;
import org.uberfire.security.auth.RoleProvider;
import org.uberfire.security.impl.auth.UsernamePasswordCredential;

public class PropertyUserSource
implements AuthenticationSource,
RoleProvider {
    private boolean alreadyInit = false;
    private Map<String, Object> credentials = new HashMap<String, Object>();
    private Map<String, List<Role>> roles = new HashMap<String, List<Role>>();

    public synchronized void initialize(Map<String, ?> options) {
        if (!this.alreadyInit) {
            InputStream is = null;
            try {
                is = options.containsKey("usersPropertyFile") ? new FileInputStream(new File((String)options.get("usersPropertyFile"))) : Thread.currentThread().getContextClassLoader().getResourceAsStream("users.properties");
                if (is == null) {
                    throw new RuntimeException("Uname to find properties file.");
                }
                Properties properties = new Properties();
                properties.load(is);
                for (Map.Entry<Object, Object> contentEntry : properties.entrySet()) {
                    String content = contentEntry.getValue().toString();
                    String[] result = content.split(",");
                    this.credentials.put(contentEntry.getKey().toString(), result[0]);
                    ArrayList<1> roles = new ArrayList<1>();
                    if (result.length <= 1) continue;
                    for (int i = 1; i < result.length; ++i) {
                        final String currentRole = result[i];
                        roles.add(new Role(){

                            public String getName() {
                                return currentRole;
                            }
                        });
                    }
                    this.roles.put(contentEntry.getKey().toString(), roles);
                }
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException(e);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            finally {
                this.alreadyInit = true;
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (Exception e) {}
                }
            }
        }
    }

    public boolean supportsCredential(Credential credential) {
        if (credential == null) {
            return false;
        }
        return credential instanceof UsernamePasswordCredential;
    }

    public boolean authenticate(Credential credential) {
        UsernamePasswordCredential usernamePasswd = (UsernamePasswordCredential)PreconditionsServer.checkInstanceOf((String)"credential", (Object)credential, UsernamePasswordCredential.class);
        Object pass = this.credentials.get(usernamePasswd.getUserName());
        return pass != null && pass.equals(usernamePasswd.getPassword());
    }

    public List<Role> loadRoles(Principal principal) {
        return this.roles.get(principal.getName());
    }
}

