/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.security.server.cdi;

import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.inject.Produces;
import org.uberfire.security.Identity;
import org.uberfire.security.Role;
import org.uberfire.security.Subject;
import org.uberfire.security.authz.AuthorizationManager;

public class SecurityFactory {
    private static final ThreadLocal<Subject> subjects = new ThreadLocal();
    private static AuthorizationManager authzManager = null;

    public static void setSubject(Subject subject) {
        subjects.set(subject);
    }

    public static void setAuthzManager(AuthorizationManager authzManager) {
        SecurityFactory.authzManager = authzManager;
    }

    @Produces
    @RequestScoped
    public static Identity getIdentity() {
        return new Identity(){

            public List<Role> getRoles() {
                return ((Subject)subjects.get()).getRoles();
            }

            public boolean hasRole(Role role) {
                return ((Subject)subjects.get()).hasRole(role);
            }

            public String getName() {
                return ((Subject)subjects.get()).getName();
            }
        };
    }

    @Produces
    @ApplicationScoped
    public static AuthorizationManager getAuthzManager() {
        return authzManager;
    }
}

