/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.workbench.model.impl;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.workbench.model.PartDefinition;
import org.uberfire.workbench.model.impl.PanelDefinitionImpl;
import org.uberfire.workbench.model.impl.PartDefinitionImpl;

public class PanelDefinitionImplTest {
    private PanelDefinitionImpl panelDefinition;
    private PanelDefinitionImpl otherPanel;
    private PartDefinition part;
    private PlaceRequest placeRequest;

    @Before
    public void setUp() throws Exception {
        this.panelDefinition = new PanelDefinitionImpl();
        this.otherPanel = new PanelDefinitionImpl();
        this.placeRequest = (PlaceRequest)Mockito.mock(PlaceRequest.class);
        this.part = new PartDefinitionImpl(this.placeRequest);
    }

    @Test
    public void addPartTest() throws Exception {
        Assert.assertFalse((boolean)this.panelDefinition.getParts().contains(this.part));
        this.panelDefinition.addPart(this.part);
        Assert.assertTrue((boolean)this.panelDefinition.getParts().contains(this.part));
    }

    @Test
    public void addPartToADifferentPanelChangePanel() throws Exception {
        Assert.assertFalse((boolean)this.panelDefinition.getParts().contains(this.part));
        this.panelDefinition.addPart(this.part);
        Assert.assertTrue((boolean)this.panelDefinition.getParts().contains(this.part));
        this.otherPanel.addPart(this.part);
        Assert.assertTrue((boolean)this.otherPanel.getParts().contains(this.part));
        Assert.assertEquals((Object)this.otherPanel, (Object)this.part.getParentPanel());
        Assert.assertFalse((boolean)this.panelDefinition.getParts().contains(this.part));
    }

    @Test
    public void addPartTwiceShouldWork() throws Exception {
        Assert.assertFalse((boolean)this.panelDefinition.getParts().contains(this.part));
        this.panelDefinition.addPart(this.part);
        this.panelDefinition.addPart(this.part);
        Assert.assertTrue((boolean)this.panelDefinition.getParts().contains(this.part));
    }
}

