/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.mvp.impl;

import org.junit.Assert;
import org.junit.Test;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.ConditionalPlaceRequest;
import org.uberfire.mvp.impl.DefaultPlaceRequest;

public class ConditionalPlaceRequestTest {
    @Test
    public void conditionalTestTruePredicate() {
        DefaultPlaceRequest other = new DefaultPlaceRequest("other");
        ConditionalPlaceRequest dora = (ConditionalPlaceRequest)new ConditionalPlaceRequest("dora").when(p -> true).orElse((PlaceRequest)other);
        Assert.assertEquals((Object)dora, (Object)dora.resolveConditionalPlaceRequest());
    }

    @Test
    public void conditionalTestFalsePredicate() {
        DefaultPlaceRequest other = new DefaultPlaceRequest("other");
        ConditionalPlaceRequest dora = (ConditionalPlaceRequest)new ConditionalPlaceRequest("dora").when(p -> false).orElse((PlaceRequest)other);
        Assert.assertEquals((Object)other, (Object)dora.resolveConditionalPlaceRequest());
    }

    @Test
    public void incompleteConditionalShouldReturnDefaultPlaceRequest() {
        ConditionalPlaceRequest dora = new ConditionalPlaceRequest("dora");
        Assert.assertEquals((Object)"dora", (Object)dora.resolveConditionalPlaceRequest().getIdentifier());
    }

    @Test
    public void incompleteConditionalWithNullsShouldReturnDefaultPlaceRequest() {
        ConditionalPlaceRequest dora = (ConditionalPlaceRequest)new ConditionalPlaceRequest("dora").when(null).orElse(null);
        Assert.assertEquals((Object)"dora", (Object)dora.resolveConditionalPlaceRequest().getIdentifier());
    }

    @Test
    public void conditionalTestChainingPredicate() {
        DefaultPlaceRequest my = new DefaultPlaceRequest("my");
        ConditionalPlaceRequest bento = (ConditionalPlaceRequest)new ConditionalPlaceRequest("bento").when(p -> false).orElse((PlaceRequest)my);
        ConditionalPlaceRequest dora = (ConditionalPlaceRequest)new ConditionalPlaceRequest("dora").when(p -> false).orElse((PlaceRequest)bento);
        Assert.assertEquals((Object)my, (Object)dora.resolveConditionalPlaceRequest());
    }

    @Test
    public void conditionalTestChainingPredicateReturningConditional() {
        DefaultPlaceRequest my = new DefaultPlaceRequest("my");
        ConditionalPlaceRequest bento = (ConditionalPlaceRequest)new ConditionalPlaceRequest("bento").when(p -> true).orElse((PlaceRequest)my);
        ConditionalPlaceRequest dora = (ConditionalPlaceRequest)new ConditionalPlaceRequest("dora").when(p -> false).orElse((PlaceRequest)bento);
        Assert.assertEquals((Object)"bento", (Object)dora.resolveConditionalPlaceRequest().getIdentifier());
    }
}

