/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.mvp.impl;

import org.junit.Assert;
import org.junit.Test;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.ConditionalPlaceRequest;
import org.uberfire.mvp.impl.DefaultPlaceRequest;

public class ConditionalPlaceRequestTest {
    @Test
    public void conditionalTestTruePredicate() {
        DefaultPlaceRequest other = new DefaultPlaceRequest("other");
        ConditionalPlaceRequest dora = (ConditionalPlaceRequest)new ConditionalPlaceRequest("dora").when(p -> true).orElse((PlaceRequest)other);
        Assert.assertEquals((Object)dora, (Object)dora.resolveConditionalPlaceRequest());
    }

    @Test
    public void conditionalTestFalsePredicate() {
        DefaultPlaceRequest other = new DefaultPlaceRequest("other");
        ConditionalPlaceRequest dora = (ConditionalPlaceRequest)new ConditionalPlaceRequest("dora").when(p -> false).orElse((PlaceRequest)other);
        Assert.assertEquals((Object)other, (Object)dora.resolveConditionalPlaceRequest());
    }

    @Test
    public void incompleteConditionalShouldReturnDefaultPlaceRequest() {
        ConditionalPlaceRequest dora = new ConditionalPlaceRequest("dora");
        Assert.assertEquals((Object)"dora", (Object)dora.resolveConditionalPlaceRequest().getIdentifier());
    }

    @Test
    public void incompleteConditionalWithNullsShouldReturnDefaultPlaceRequest() {
        ConditionalPlaceRequest dora = (ConditionalPlaceRequest)new ConditionalPlaceRequest("dora").when(null).orElse(null);
        Assert.assertEquals((Object)"dora", (Object)dora.resolveConditionalPlaceRequest().getIdentifier());
    }

    @Test
    public void conditionalTestChainingPredicate() {
        DefaultPlaceRequest my = new DefaultPlaceRequest("my");
        ConditionalPlaceRequest bento = (ConditionalPlaceRequest)new ConditionalPlaceRequest("bento").when(p -> false).orElse((PlaceRequest)my);
        ConditionalPlaceRequest dora = (ConditionalPlaceRequest)new ConditionalPlaceRequest("dora").when(p -> false).orElse((PlaceRequest)bento);
        Assert.assertEquals((Object)my, (Object)dora.resolveConditionalPlaceRequest());
    }

    @Test
    public void conditionalTestChainingPredicateReturningConditional() {
        DefaultPlaceRequest my = new DefaultPlaceRequest("my");
        ConditionalPlaceRequest bento = (ConditionalPlaceRequest)new ConditionalPlaceRequest("bento").when(p -> true).orElse((PlaceRequest)my);
        ConditionalPlaceRequest dora = (ConditionalPlaceRequest)new ConditionalPlaceRequest("dora").when(p -> false).orElse((PlaceRequest)bento);
        Assert.assertEquals((Object)"bento", (Object)dora.resolveConditionalPlaceRequest().getIdentifier());
    }

    @Test
    public void defaultPlaceRequestEqualsToConditionalPlaceRequest() {
        DefaultPlaceRequest defaultPlaceRequest = new DefaultPlaceRequest("my");
        PlaceRequest conditionalPlaceRequest = new ConditionalPlaceRequest("my").when(p -> true).orElse((PlaceRequest)new DefaultPlaceRequest("other"));
        this.equals((PlaceRequest)defaultPlaceRequest, conditionalPlaceRequest);
    }

    @Test
    public void defaultPlaceRequestNotEqualsToConditionalPlaceRequest() {
        DefaultPlaceRequest defaultPlaceRequest = new DefaultPlaceRequest("my");
        PlaceRequest conditionalPlaceRequest = new ConditionalPlaceRequest("my").when(p -> false).orElse((PlaceRequest)new DefaultPlaceRequest("other"));
        this.notEquals((PlaceRequest)defaultPlaceRequest, conditionalPlaceRequest);
    }

    @Test
    public void defaultPlaceRequestEqualsToIncompleteConditionalPlaceRequest() {
        DefaultPlaceRequest defaultPlaceRequest = new DefaultPlaceRequest("my");
        ConditionalPlaceRequest conditionalPlaceRequest = new ConditionalPlaceRequest("my");
        this.equals((PlaceRequest)defaultPlaceRequest, (PlaceRequest)conditionalPlaceRequest);
    }

    @Test
    public void trueEvaluatedConditionalPlaceRequestEqualsToAnotherTrueEvaluatedConditionalPlaceRequest() {
        PlaceRequest conditionalPlaceRequest1 = new ConditionalPlaceRequest("place1").when(p -> true).orElse((PlaceRequest)new DefaultPlaceRequest("place2"));
        PlaceRequest conditionalPlaceRequest2 = new ConditionalPlaceRequest("place1").when(p -> true).orElse((PlaceRequest)new DefaultPlaceRequest("place3"));
        this.equals(conditionalPlaceRequest1, conditionalPlaceRequest2);
    }

    @Test
    public void falseEvaluatedConditionalPlaceRequestEqualsToAnotherFalseEvaluatedConditionalPlaceRequest() {
        PlaceRequest conditionalPlaceRequest1 = new ConditionalPlaceRequest("place1").when(p -> false).orElse((PlaceRequest)new DefaultPlaceRequest("place2"));
        PlaceRequest conditionalPlaceRequest2 = new ConditionalPlaceRequest("place3").when(p -> false).orElse((PlaceRequest)new DefaultPlaceRequest("place2"));
        this.equals(conditionalPlaceRequest1, conditionalPlaceRequest2);
    }

    @Test
    public void trueEvaluatedConditionalPlaceRequestEqualsToAnotherFalseEvaluatedConditionalPlaceRequest() {
        PlaceRequest conditionalPlaceRequest1 = new ConditionalPlaceRequest("place1").when(p -> true).orElse((PlaceRequest)new DefaultPlaceRequest("place2"));
        PlaceRequest conditionalPlaceRequest2 = new ConditionalPlaceRequest("place3").when(p -> false).orElse((PlaceRequest)new DefaultPlaceRequest("place1"));
        this.equals(conditionalPlaceRequest1, conditionalPlaceRequest2);
    }

    @Test
    public void falseEvaluatedConditionalPlaceRequestEqualsToAnotherTrueEvaluatedConditionalPlaceRequest() {
        PlaceRequest conditionalPlaceRequest1 = new ConditionalPlaceRequest("place1").when(p -> false).orElse((PlaceRequest)new DefaultPlaceRequest("place2"));
        PlaceRequest conditionalPlaceRequest2 = new ConditionalPlaceRequest("place2").when(p -> true).orElse((PlaceRequest)new DefaultPlaceRequest("place3"));
        this.equals(conditionalPlaceRequest1, conditionalPlaceRequest2);
    }

    private void equals(PlaceRequest placeRequest1, PlaceRequest placeRequest2) {
        Assert.assertTrue((boolean)placeRequest1.equals(placeRequest2));
        Assert.assertTrue((boolean)placeRequest2.equals(placeRequest1));
        Assert.assertEquals((long)placeRequest1.hashCode(), (long)placeRequest2.hashCode());
    }

    private void notEquals(PlaceRequest placeRequest1, PlaceRequest placeRequest2) {
        Assert.assertFalse((boolean)placeRequest1.equals(placeRequest2));
        Assert.assertFalse((boolean)placeRequest2.equals(placeRequest1));
        Assert.assertNotEquals((long)placeRequest1.hashCode(), (long)placeRequest2.hashCode());
    }
}

