/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.workbench.model.impl;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.workbench.model.PanelDefinition;
import org.uberfire.workbench.model.PartDefinition;
import org.uberfire.workbench.model.impl.PanelDefinitionImpl;
import org.uberfire.workbench.model.impl.PartDefinitionImpl;

public class PanelDefinitionImplTest {
    private PanelDefinitionImpl panelDefinition;
    private PanelDefinitionImpl otherPanel;
    private PartDefinition part;
    private PlaceRequest placeRequest;
    private PanelDefinitionImpl parent;

    @Before
    public void setUp() throws Exception {
        this.panelDefinition = new PanelDefinitionImpl();
        this.otherPanel = new PanelDefinitionImpl();
        this.parent = new PanelDefinitionImpl();
        this.placeRequest = (PlaceRequest)Mockito.mock(PlaceRequest.class);
        this.part = new PartDefinitionImpl(this.placeRequest);
    }

    @Test(expected=IllegalStateException.class)
    public void settingTwoDifferentParentsShouldThrowException() throws Exception {
        this.panelDefinition.setParent((PanelDefinition)this.otherPanel);
        this.panelDefinition.setParent((PanelDefinition)this.parent);
    }

    @Test
    public void addPartTest() throws Exception {
        Assert.assertFalse((boolean)this.panelDefinition.getParts().contains(this.part));
        this.panelDefinition.addPart(this.part);
        Assert.assertTrue((boolean)this.panelDefinition.getParts().contains(this.part));
    }

    @Test
    public void addPartToADifferentPanelChangePanel() throws Exception {
        Assert.assertFalse((boolean)this.panelDefinition.getParts().contains(this.part));
        this.panelDefinition.addPart(this.part);
        Assert.assertTrue((boolean)this.panelDefinition.getParts().contains(this.part));
        this.otherPanel.addPart(this.part);
        Assert.assertTrue((boolean)this.otherPanel.getParts().contains(this.part));
        Assert.assertEquals((Object)this.otherPanel, (Object)this.part.getParentPanel());
        Assert.assertFalse((boolean)this.panelDefinition.getParts().contains(this.part));
    }

    @Test
    public void addPartTwiceShouldWork() throws Exception {
        Assert.assertFalse((boolean)this.panelDefinition.getParts().contains(this.part));
        this.panelDefinition.addPart(this.part);
        this.panelDefinition.addPart(this.part);
        Assert.assertTrue((boolean)this.panelDefinition.getParts().contains(this.part));
    }

    @Test
    public void partShouldNotBePresentAfterRemoval() throws Exception {
        this.panelDefinition.addPart(this.part);
        Assert.assertNotNull((Object)this.part.getParentPanel());
        Assert.assertTrue((boolean)this.panelDefinition.getParts().contains(this.part));
        this.panelDefinition.removePart(this.part);
        Assert.assertNull((Object)this.part.getParentPanel());
        Assert.assertFalse((boolean)this.panelDefinition.getParts().contains(this.part));
    }

    @Test
    public void removeNonexistentPartShouldDoNothingAndReturnFalse() throws Exception {
        boolean result = this.panelDefinition.removePart(this.part);
        Assert.assertEquals((Object)false, (Object)result);
    }

    @Test
    public void widthShouldNotRevertOnceSet() throws Exception {
        Assert.assertNull((Object)this.panelDefinition.getWidth());
        this.panelDefinition.setWidth(1234);
        this.panelDefinition.setWidth(null);
        Assert.assertEquals((Object)1234, (Object)this.panelDefinition.getWidth());
    }

    @Test
    public void heightShouldNotRevertOnceSet() throws Exception {
        Assert.assertNull((Object)this.panelDefinition.getHeight());
        this.panelDefinition.setHeight(1234);
        this.panelDefinition.setHeight(null);
        Assert.assertEquals((Object)1234, (Object)this.panelDefinition.getHeight());
    }

    @Test
    public void appendChildShouldAddPanelToChildren() {
        this.panelDefinition.appendChild((PanelDefinition)this.otherPanel);
        Assert.assertTrue((boolean)this.panelDefinition.getChildren().contains(this.otherPanel));
        Assert.assertEquals((Object)this.panelDefinition, (Object)this.otherPanel.getParent());
    }

    @Test
    public void appendChildToPanelTwiceShouldWork() {
        this.panelDefinition.appendChild((PanelDefinition)this.otherPanel);
        Assert.assertTrue((boolean)this.panelDefinition.getChildren().contains(this.otherPanel));
        this.panelDefinition.appendChild((PanelDefinition)this.otherPanel);
        Assert.assertTrue((boolean)this.panelDefinition.getChildren().contains(this.otherPanel));
    }
}

