/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.workbench.type;

import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.uberfire.backend.vfs.Path;
import org.uberfire.workbench.type.FileNameUtil;
import org.uberfire.workbench.type.ResourceTypeDefinition;

public class FileNameUtilTest {
    @Test
    public void removeExtensionFromFileNameTest() {
        Assert.assertNull((Object)FileNameUtil.removeExtension((String)null, (String)".java"));
        Assert.assertEquals((Object)"file.java", (Object)FileNameUtil.removeExtension((String)"file.java", null));
        Assert.assertEquals((Object)"file.java", (Object)FileNameUtil.removeExtension((String)"file.java", (String)""));
        Assert.assertEquals((Object)"file", (Object)FileNameUtil.removeExtension((String)"file.java", (String)"java"));
    }

    @Test
    public void removeExtensionFromPathTest() {
        Path path = (Path)Mockito.mock(Path.class);
        ((Path)Mockito.doReturn((Object)"file.java").when((Object)path)).getFileName();
        Assert.assertNull((Object)FileNameUtil.removeExtension((Path)null, (String)".java"));
        Assert.assertEquals((Object)"file.java", (Object)FileNameUtil.removeExtension((Path)path, (String)null));
        Assert.assertEquals((Object)"file.java", (Object)FileNameUtil.removeExtension((Path)path, (String)""));
        Assert.assertEquals((Object)"file", (Object)FileNameUtil.removeExtension((Path)path, (String)"java"));
    }

    @Test
    public void removeResourceTypeDefinitionSuffixFromPathTest() {
        Path path = (Path)Mockito.mock(Path.class);
        ((Path)Mockito.doReturn((Object)"file.java").when((Object)path)).getFileName();
        ResourceTypeDefinition resourceTypeDefinition = (ResourceTypeDefinition)Mockito.mock(ResourceTypeDefinition.class);
        ((ResourceTypeDefinition)Mockito.doReturn((Object)"java").when((Object)resourceTypeDefinition)).getSuffix();
        Assert.assertNull((Object)FileNameUtil.removeExtension((Path)null, (String)".java"));
        Assert.assertEquals((Object)"file", (Object)FileNameUtil.removeExtension((Path)path, (ResourceTypeDefinition)resourceTypeDefinition));
    }
}

