/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.apps.api;

import java.util.HashMap;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.uberfire.ext.apps.api.Directory;
import org.uberfire.ext.apps.api.DirectoryBreadcrumb;

public class DirectoryBreadcrumbTest {
    private static final String TOP_DIR_NAME = "top";
    private static final String MIDDLE_DIR_NAME = "middle";
    private static final String LOW_DIR_NAME = "low";
    private static final String OTHER_DIR_NAME = "other";

    @Test
    public void breadcrumbsOrderTest() {
        Directory topDir = new Directory(TOP_DIR_NAME, "", "", new HashMap());
        Directory middleDir = new Directory(MIDDLE_DIR_NAME, "", "", topDir);
        Directory lowDir = new Directory(LOW_DIR_NAME, "", "", middleDir);
        Directory otherDir = new Directory(OTHER_DIR_NAME, "", "", topDir);
        this.assertDirectoryBreadcrumbs(topDir, TOP_DIR_NAME);
        this.assertDirectoryBreadcrumbs(middleDir, TOP_DIR_NAME, MIDDLE_DIR_NAME);
        this.assertDirectoryBreadcrumbs(lowDir, TOP_DIR_NAME, MIDDLE_DIR_NAME, LOW_DIR_NAME);
        this.assertDirectoryBreadcrumbs(otherDir, TOP_DIR_NAME, OTHER_DIR_NAME);
    }

    private void assertDirectoryBreadcrumbs(Directory workingDir, String ... expectedNames) {
        List breadcrumbs = DirectoryBreadcrumb.getBreadcrumbs((Directory)workingDir);
        int breadcrumbsSize = breadcrumbs.size();
        Assert.assertEquals((long)expectedNames.length, (long)breadcrumbsSize);
        for (int i = 0; i < breadcrumbsSize; ++i) {
            Assert.assertEquals((Object)expectedNames[i], (Object)((DirectoryBreadcrumb)breadcrumbs.get(i)).getName());
        }
    }
}

