/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.backend.server;

import com.thoughtworks.xstream.XStream;
import java.util.HashMap;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.jboss.errai.bus.server.annotations.Service;
import org.kie.commons.io.IOService;
import org.kie.commons.java.nio.file.NoSuchFileException;
import org.kie.commons.java.nio.file.OpenOption;
import org.kie.commons.java.nio.file.Path;
import org.uberfire.client.workbench.model.PerspectiveDefinition;
import org.uberfire.client.workbench.services.UserServices;
import org.uberfire.client.workbench.services.WorkbenchServices;

@Service
@ApplicationScoped
public class WorkbenchServicesImpl
implements WorkbenchServices {
    @Inject
    @Named(value="ioStrategy")
    private IOService ioService;
    @Inject
    private UserServices userServices;
    private XStream xs = new XStream();

    public void save(PerspectiveDefinition perspective) {
        String xml = this.xs.toXML((Object)perspective);
        Path perspectivePath = this.userServices.buildPath("perspectives", perspective.getName() + ".perspective");
        this.ioService.write(perspectivePath, xml, new OpenOption[0]);
    }

    public PerspectiveDefinition load(String perspectiveName) {
        Path perspectivePath = this.userServices.buildPath("perspectives", perspectiveName + ".perspective");
        if (this.ioService.exists(perspectivePath)) {
            String xml = this.ioService.readAllString(perspectivePath);
            return (PerspectiveDefinition)this.xs.fromXML(xml);
        }
        return null;
    }

    public Map<String, String> loadDefaultEditorsMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            Path path = this.getPathToDefaultEditors();
            if (this.ioService.exists(path)) {
                for (String line : this.ioService.readAllLines(path)) {
                    if (line.trim().startsWith("#")) continue;
                    String[] split = line.split("=");
                    map.put(split[0], split[1]);
                }
            }
            return map;
        }
        catch (NoSuchFileException e) {
            e.printStackTrace();
            return map;
        }
    }

    public void saveDefaultEditors(Map<String, String> properties) {
        StringBuilder text = new StringBuilder();
        for (String key : properties.keySet()) {
            text.append(String.format("%s=%s", key, properties.get(key)));
        }
        this.ioService.write(this.getPathToDefaultEditors(), text.toString(), new OpenOption[0]);
    }

    private Path getPathToDefaultEditors() {
        return this.userServices.buildPath("defaultEditors", null);
    }
}

