/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.backend.server;

import java.util.Iterator;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.SessionScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.kie.commons.io.FileSystemType;
import org.kie.commons.io.IOService;
import org.kie.commons.java.nio.file.FileSystem;
import org.kie.commons.java.nio.file.Path;
import org.uberfire.security.Identity;

@ApplicationScoped
public class UserServicesImpl {
    @Inject
    @Named(value="ioStrategy")
    private IOService ioService;
    @Inject
    @SessionScoped
    private Identity identity;
    private Path bootstrapRoot = null;

    @PostConstruct
    public void init() {
        FileSystem bootstrap;
        Iterator rootIterator;
        Iterator fsIterator = this.ioService.getFileSystems((FileSystemType)FileSystemType.Bootstrap.BOOTSTRAP_INSTANCE).iterator();
        if (fsIterator.hasNext() && (rootIterator = (bootstrap = (FileSystem)fsIterator.next()).getRootDirectories().iterator()).hasNext()) {
            this.bootstrapRoot = (Path)rootIterator.next();
        }
    }

    public Path buildPath(String serviceType, String relativePath) {
        if (relativePath != null && !"".equals(relativePath)) {
            return this.bootstrapRoot.resolve("/.metadata/.users/" + this.identity.getName() + "/." + serviceType + "/." + relativePath);
        }
        return this.bootstrapRoot.resolve("/.metadata/.users/" + this.identity.getName() + "/." + serviceType);
    }

    public Path buildPath(String userName, String serviceType, String relativePath) {
        if (relativePath != null && !"".equals(relativePath)) {
            return this.bootstrapRoot.resolve("/.metadata/.users/" + userName + "/." + serviceType + "/." + relativePath);
        }
        return this.bootstrapRoot.resolve("/.metadata/.users/" + userName + "/." + serviceType);
    }
}

