/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.backend.server;

import java.util.ArrayList;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.kie.commons.io.IOWatchService;
import org.kie.commons.java.nio.base.WatchContext;
import org.kie.commons.java.nio.file.StandardWatchEventKind;
import org.kie.commons.java.nio.file.WatchEvent;
import org.kie.commons.java.nio.file.WatchKey;
import org.kie.commons.java.nio.file.WatchService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.rpc.SessionInfo;
import org.uberfire.rpc.impl.SessionInfoImpl;
import org.uberfire.security.Identity;
import org.uberfire.security.impl.IdentityImpl;
import org.uberfire.workbench.events.ResourceAddedEvent;
import org.uberfire.workbench.events.ResourceDeletedEvent;
import org.uberfire.workbench.events.ResourceRenamedEvent;
import org.uberfire.workbench.events.ResourceUpdatedEvent;

@ApplicationScoped
public class IOWatchServiceNonDotImpl
implements IOWatchService {
    private static final Logger LOGGER = LoggerFactory.getLogger(IOWatchServiceNonDotImpl.class);
    @Inject
    private Event<ResourceUpdatedEvent> resourceUpdatedEvent;
    @Inject
    private Event<ResourceRenamedEvent> resourceRenamedEvent;
    @Inject
    private Event<ResourceDeletedEvent> resourceDeletedEvent;
    @Inject
    private Event<ResourceAddedEvent> resourceAddedEvent;
    @Inject
    private Paths paths;
    private final List<WatchService> watchServices = new ArrayList<WatchService>();
    private boolean isDisposed = false;

    public void dispose() {
        this.isDisposed = true;
        for (WatchService watchService : this.watchServices) {
            watchService.close();
        }
    }

    public void addWatchService(final WatchService ws) {
        this.watchServices.add(ws);
        new Thread("IOWatchServiceNonDotImpl(" + ws.toString() + ")"){

            @Override
            public void run() {
                while (!IOWatchServiceNonDotImpl.this.isDisposed) {
                    WatchKey wk = ws.take();
                    if (wk == null) continue;
                    List events = wk.pollEvents();
                    for (WatchEvent object : events) {
                        WatchContext context = (WatchContext)object.context();
                        try {
                            if (object.kind().equals(StandardWatchEventKind.ENTRY_MODIFY)) {
                                if (context.getOldPath().getFileName().toString().startsWith(".")) continue;
                                IOWatchServiceNonDotImpl.this.resourceUpdatedEvent.fire((Object)new ResourceUpdatedEvent(IOWatchServiceNonDotImpl.this.paths.convert(context.getOldPath()), IOWatchServiceNonDotImpl.this.sessionInfo(context)));
                                continue;
                            }
                            if (object.kind().equals(StandardWatchEventKind.ENTRY_CREATE)) {
                                if (context.getPath().getFileName().toString().startsWith(".")) continue;
                                IOWatchServiceNonDotImpl.this.resourceAddedEvent.fire((Object)new ResourceAddedEvent(IOWatchServiceNonDotImpl.this.paths.convert(context.getPath()), IOWatchServiceNonDotImpl.this.sessionInfo(context)));
                                continue;
                            }
                            if (object.kind().equals(StandardWatchEventKind.ENTRY_RENAME)) {
                                if (context.getOldPath().getFileName().toString().startsWith(".")) continue;
                                IOWatchServiceNonDotImpl.this.resourceRenamedEvent.fire((Object)new ResourceRenamedEvent(IOWatchServiceNonDotImpl.this.paths.convert(context.getOldPath(), false), IOWatchServiceNonDotImpl.this.paths.convert(context.getPath()), IOWatchServiceNonDotImpl.this.sessionInfo(context)));
                                continue;
                            }
                            if (!object.kind().equals(StandardWatchEventKind.ENTRY_DELETE) || context.getOldPath().getFileName().toString().startsWith(".")) continue;
                            IOWatchServiceNonDotImpl.this.resourceDeletedEvent.fire((Object)new ResourceDeletedEvent(IOWatchServiceNonDotImpl.this.paths.convert(context.getOldPath(), false), IOWatchServiceNonDotImpl.this.sessionInfo(context)));
                        }
                        catch (Exception ex) {
                            LOGGER.error("Unexpected error during WatchService events fire.", (Throwable)ex);
                        }
                    }
                }
            }
        }.start();
    }

    private SessionInfo sessionInfo(WatchContext context) {
        String sessionId = context.getSessionId() == null ? "<system>" : context.getSessionId();
        String user = context.getUser() == null ? "<system>" : context.getUser();
        return new SessionInfoImpl(sessionId, (Identity)new IdentityImpl(user));
    }
}

